/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class MurdererSkill
extends Skill {
    private static final String MURDERER = "590dd021-c704-4d79-80bf-2704e1ea0c39";

    public MurdererSkill() {
        super(Skill.SkillType.UNIQUE);
        this.addHeldAttributeModifier(Attributes.f_22281_, MURDERER, 50.0, AttributeModifier.Operation.ADDITION);
    }

    @Override
    public double getObtainingEpCost() {
        return 30000.0;
    }

    @Override
    public double learningCost() {
        return 100.0;
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return true;
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 50.0;
    }

    public double getAttributeModifierAmplifier(ManasSkillInstance instance, LivingEntity entity, AttributeModifier modifier) {
        return modifier.m_22218_() * (double)(instance.isMastered(entity) ? 3 : 1);
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (heldTicks % 20 == 0 && SkillHelper.outOfMagicule(entity, instance)) {
            return false;
        }
        if (heldTicks % 100 == 0 && heldTicks > 0) {
            this.addMasteryPoint(instance, entity);
        }
        entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.PRESENCE_CONCEALMENT.get(), 5, 2, false, false, false));
        return true;
    }
}

