/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class MercilessSkill
extends Skill {
    public MercilessSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    @Override
    public double getObtainingEpCost() {
        return 50000.0;
    }

    @Override
    public double learningCost() {
        return 1000.0;
    }

    @Override
    public int modes() {
        return 2;
    }

    @Override
    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        return instance.getMode() == 1 ? 2 : 1;
    }

    @Override
    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"tensura.skill.mode.merciless.steal");
            case 2 -> Component.m_237115_((String)"tensura.skill.mode.merciless.consume");
            default -> Component.m_237119_();
        };
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 100.0;
    }

    public void onDamageEntity(ManasSkillInstance instance, LivingEntity attacker, LivingHurtEvent e) {
        if (instance.getMode() != 2) {
            return;
        }
        if (!this.isInSlot(attacker)) {
            return;
        }
        LivingEntity target = e.getEntity();
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            if (!SkillHelper.outOfMagicule((LivingEntity)player, instance)) {
                SkillHelper.addEffectWithSource(target, (LivingEntity)player, (MobEffect)TensuraMobEffects.SOUL_DRAIN.get(), 100, 0);
            }
        } else {
            target.m_147207_(new MobEffectInstance((MobEffect)TensuraMobEffects.SOUL_DRAIN.get(), 100, 0, false, false), (Entity)attacker);
        }
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity living, int heldTicks) {
        if (instance.getMode() != 1) {
            return false;
        }
        if (heldTicks % 20 == 0 && SkillHelper.outOfMagicule(living, instance)) {
            return false;
        }
        if (heldTicks % 60 == 0 && heldTicks > 0) {
            this.addMasteryPoint(instance, living);
        }
        living.m_9236_().m_6263_(null, living.m_20185_(), living.m_20186_(), living.m_20189_(), SoundEvents.f_12404_, SoundSource.PLAYERS, 1.0f, 1.0f);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)living, (ParticleOptions)TensuraParticles.SOUL.get(), 1.0);
        List list = living.m_9236_().m_6443_(LivingEntity.class, living.m_20191_().m_82400_(15.0), entity -> !entity.m_7306_((Entity)living) && entity.m_6084_() && !entity.m_7307_((Entity)living));
        if (!list.isEmpty()) {
            double ownerEP = TensuraEPCapability.getEP(living);
            for (LivingEntity target : list) {
                if (target instanceof Player) {
                    Player player = (Player)target;
                    if (player.m_150110_().f_35934_) continue;
                }
                MobEffectInstance fear = target.m_21124_((MobEffect)TensuraMobEffects.FEAR.get());
                boolean shouldConsume = (double)target.m_21223_() < (double)target.m_21233_() * 0.1 || TensuraEPCapability.getEP(target) < ownerEP * 0.1 || fear != null && fear.m_19564_() >= 4;
                if (!shouldConsume) continue;
                target.m_6469_((DamageSource)this.sourceWithMP(TensuraDamageSources.soulConsume((Entity)living), living, instance), target.m_21233_() * 10.0f);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)TensuraParticles.SOUL.get(), 1.0);
            }
        }
        return true;
    }
}

