/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.attribute.ManasCoreAttributes;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.extra.ThoughtAccelerationSkill;
import com.github.manasmods.tensura.capability.skill.TensuraSkillCapability;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class MathematicianSkill
extends Skill {
    protected static final UUID ACCELERATION = UUID.fromString("3e3e55b1-48b9-4d22-9ccc-7582c163a138");

    public MathematicianSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    @Override
    protected boolean canActivateInRaceLimit(ManasSkillInstance instance) {
        return true;
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return instance.getMastery() >= 0;
    }

    public void onBeingDamaged(ManasSkillInstance instance, LivingAttackEvent event) {
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (!this.isInSlot(entity)) {
            return;
        }
        DamageSource damageSource = event.getSource();
        if (damageSource.m_19378_() || damageSource.m_19387_()) {
            return;
        }
        if (damageSource.m_7640_() == null || damageSource.m_7640_() != damageSource.m_7639_()) {
            return;
        }
        if (entity.m_217043_().m_188501_() > 0.25f) {
            return;
        }
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 2.0f, 1.0f);
        event.setCanceled(true);
        if (SkillUtils.canNegateDodge(entity, damageSource)) {
            event.setCanceled(false);
        }
    }

    public void onProjectileHit(ManasSkillInstance instance, LivingEntity entity, ProjectileImpactEvent event) {
        if (!this.isInSlot(entity)) {
            return;
        }
        if (SkillUtils.isProjectileAlwaysHit(event.getProjectile())) {
            return;
        }
        if (entity.m_217043_().m_188501_() > 0.25f) {
            return;
        }
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 2.0f, 1.0f);
        event.setCanceled(true);
    }

    public void onDamageEntity(ManasSkillInstance instance, LivingEntity attacker, LivingHurtEvent e) {
        if (!this.isInSlot(attacker)) {
            return;
        }
        DamageSource source = e.getSource();
        if (source.m_7640_() != attacker) {
            return;
        }
        if (!DamageSourceHelper.isPhysicalAttack(source)) {
            return;
        }
        if ((double)attacker.m_217043_().m_188501_() <= 0.75) {
            return;
        }
        LivingEntity entity = e.getEntity();
        if (SkillUtils.canNegateCritChance((Entity)entity)) {
            return;
        }
        double critical = attacker.m_21133_((Attribute)ManasCoreAttributes.CRIT_MULTIPLIER.get());
        e.setAmount((float)((double)e.getAmount() * critical));
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12313_, attacker.m_5720_(), 1.0f, 1.0f);
        Level level = attacker.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            level2.m_7726_().m_8394_((Entity)attacker, (Packet)new ClientboundAnimatePacket((Entity)entity, 4));
        }
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        TensuraSkillCapability.getFrom(player).ifPresent(cap -> {
            int level;
            if (player.m_6047_()) {
                int mode = cap.getAnalysisMode();
                switch (mode) {
                    case 1: {
                        cap.setAnalysisMode(2);
                        player.m_5661_((Component)Component.m_237115_((String)"tensura.skill.analytical.analyzing_mode.block").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA)), true);
                        break;
                    }
                    case 2: {
                        cap.setAnalysisMode(0);
                        player.m_5661_((Component)Component.m_237115_((String)"tensura.skill.analytical.analyzing_mode.both").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA)), true);
                        break;
                    }
                    default: {
                        cap.setAnalysisMode(1);
                        player.m_5661_((Component)Component.m_237115_((String)"tensura.skill.analytical.analyzing_mode.entity").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA)), true);
                    }
                }
                player.m_6330_(SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
                TensuraSkillCapability.sync(player);
                return;
            }
            int n = level = instance.isMastered(entity) ? 12 : 8;
            if (cap.getAnalysisLevel() != level) {
                cap.setAnalysisLevel(level);
                cap.setAnalysisDistance(instance.isMastered(entity) ? 20 : 10);
                entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
            } else {
                cap.setAnalysisLevel(0);
                entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            TensuraSkillCapability.sync(player);
        });
    }

    public void onToggleOn(ManasSkillInstance instance, LivingEntity entity) {
        ThoughtAccelerationSkill.onToggle(instance, entity, ACCELERATION, true);
    }

    public void onToggleOff(ManasSkillInstance instance, LivingEntity entity) {
        ThoughtAccelerationSkill.onToggle(instance, entity, ACCELERATION, false);
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        return instance.isToggled() || this.isInSlot(entity);
    }

    public void onTick(ManasSkillInstance instance, LivingEntity entity) {
        CompoundTag tag = instance.getOrCreateTag();
        int time = tag.m_128451_("activatedTimes");
        if (time % 12 == 0) {
            this.addMasteryPoint(instance, entity);
        }
        tag.m_128405_("activatedTimes", time + 1);
    }
}

