/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2client.RequestFxSpawningPacket;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;

public class LustSkill
extends Skill {
    public LustSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    @Override
    public double getObtainingEpCost() {
        return 100000.0;
    }

    @Override
    public int getMaxMastery() {
        return 1500;
    }

    @Override
    public double learningCost() {
        return 5000.0;
    }

    @Override
    public int modes() {
        return 5;
    }

    @Override
    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return switch (instance.getMode()) {
                case 5 -> 4;
                case 4 -> 3;
                case 3 -> 2;
                case 2 -> 1;
                case 1 -> {
                    if (this.isMastered(instance, entity)) {
                        yield 5;
                    }
                    yield 4;
                }
                default -> 0;
            };
        }
        return switch (instance.getMode()) {
            case 4 -> {
                if (this.isMastered(instance, entity)) {
                    yield 5;
                }
                yield 1;
            }
            case 3 -> 4;
            case 2 -> 3;
            case 1 -> 2;
            default -> 1;
        };
    }

    @Override
    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"tensura.skill.mode.lust.drain");
            case 2 -> Component.m_237115_((String)"tensura.skill.mode.lust.invigorate");
            case 3 -> Component.m_237115_((String)"tensura.skill.mode.lust.rebirth");
            case 4 -> Component.m_237115_((String)"tensura.skill.mode.lust.embracing_drain");
            case 5 -> Component.m_237115_((String)"tensura.skill.mode.lust.death_blessing");
            default -> Component.m_237119_();
        };
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 5 -> 7500.0;
            case 4 -> 500.0;
            case 3 -> 3000.0;
            case 1 -> 100.0;
            default -> 0.0;
        };
    }

    @Override
    public String modeLearningId(int mode) {
        return switch (mode) {
            case 5 -> "DeathBlessing";
            case 4 -> "EmbracingDrain";
            default -> "None";
        };
    }

    public boolean canIgnoreCoolDown(ManasSkillInstance instance, LivingEntity entity) {
        if (instance.getMastery() < 0) {
            return false;
        }
        return instance.getMode() != 4 && instance.getMode() != 5;
    }

    public boolean onHeld(ManasSkillInstance skillInstance, LivingEntity entity, int heldTicks) {
        List list;
        if (skillInstance.getMode() != 5) {
            return false;
        }
        if (skillInstance.getOrCreateTag().m_128451_("DeathBlessing") < 100) {
            return false;
        }
        if (heldTicks % 20 == 0 && SkillHelper.outOfMagicule(entity, skillInstance)) {
            return false;
        }
        if (heldTicks % 200 == 0 && heldTicks > 0) {
            this.addMasteryPoint(skillInstance, entity);
        }
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_215771_, SoundSource.PLAYERS, 1.0f, 1.0f);
        if (heldTicks % 10 == 0) {
            TensuraNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new RequestFxSpawningPacket(new ResourceLocation("tensura:death_blessing"), entity.m_19879_(), 0.0, 1.0, 0.0, true));
        }
        if (!(list = entity.m_9236_().m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(7.0), living -> !living.m_7306_((Entity)entity) && living.m_6084_())).isEmpty() && heldTicks > 0 && heldTicks % 100 == 0) {
            double ownerEP = TensuraEPCapability.getEP(entity);
            for (LivingEntity target : list) {
                double epGain;
                if (target instanceof Player) {
                    Player player = (Player)target;
                    if (player.m_150110_().f_35934_) continue;
                }
                if (target.m_6095_().m_204039_(TensuraTags.EntityTypes.NO_EP_PLUNDER)) continue;
                double targetEP = TensuraEPCapability.getEP(target);
                double difference = targetEP / ownerEP;
                if (difference <= 0.5) {
                    if (!target.m_6469_((DamageSource)this.sourceWithMP(TensuraDamageSources.deathBless((Entity)entity), entity, skillInstance), target.m_21233_() * 10.0f)) continue;
                    SkillHelper.gainMP(entity, targetEP * 0.75, false);
                    SkillHelper.gainAP(entity, targetEP * 0.25, false);
                    continue;
                }
                if (!target.m_6469_((DamageSource)this.sourceWithMP(TensuraDamageSources.deathBless((Entity)entity), entity, skillInstance), target.m_21233_() / 2.0f)) continue;
                double d = epGain = difference <= 0.75 ? targetEP * 0.25 : targetEP * 0.05;
                if (target.m_6084_()) {
                    this.reduceStat(target, epGain, entity);
                }
                SkillHelper.gainMP(entity, epGain * 0.75, false);
                SkillHelper.gainAP(entity, epGain * 0.25, false);
            }
        } else if (entity instanceof Player) {
            Player player = (Player)entity;
            int second = 5 + heldTicks / 100 * 5;
            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.time_held.max", (Object[])new Object[]{heldTicks / 20, second}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), true);
        }
        return true;
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        if (!(instance instanceof TensuraSkillInstance)) {
            return;
        }
        TensuraSkillInstance skillInstance = (TensuraSkillInstance)instance;
        Level level = entity.m_9236_();
        switch (skillInstance.getMode()) {
            case 1: {
                if (SkillHelper.outOfMagicule(entity, skillInstance)) {
                    return;
                }
                this.addMasteryPoint(skillInstance, entity);
                entity.m_21011_(InteractionHand.MAIN_HAND, true);
                LivingEntity target = SkillHelper.getTargetingEntity(entity, 5.0, false);
                if (target != null) {
                    if (target instanceof Player) {
                        Player player = (Player)target;
                        if (player.m_150110_().f_35934_) {
                            return;
                        }
                    }
                    if (!SkillHelper.drainEnergy(target, entity, 200.0, false)) break;
                    if (this.isMastered(instance, entity)) {
                        SkillHelper.drainEnergy(target, entity, 0.005, true);
                    }
                    instance.setCoolDown(1);
                    level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12053_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)TensuraParticles.YELLOW_LIGHTNING_SPARK.get());
                    break;
                }
                if (entity.m_21023_((MobEffect)TensuraMobEffects.LUST_DRAIN.get())) break;
                instance.setCoolDown(1);
                entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.LUST_DRAIN.get(), 200, this.isMastered(instance, entity) ? 1 : 0, false, false, false));
                level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12053_, SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
            case 2: {
                boolean success;
                LivingEntity target = SkillHelper.getTargetingEntity(entity, 5.0, false);
                if (target != null && entity.m_6144_()) {
                    if (target instanceof Animal) {
                        Animal animal = (Animal)target;
                        if (entity instanceof Player) {
                            Player player = (Player)entity;
                            if (animal.m_21223_() == animal.m_21233_() && animal.m_146764_() >= 0) {
                                animal.m_146762_(0);
                                animal.m_27595_(player);
                            }
                        }
                    }
                    success = SkillHelper.removePredicateEffect(target, effect -> true, this.magiculeCost(entity, instance));
                    int cost = instance.isMastered(entity) ? 40 : 80;
                    float lackedHealth = target.m_21233_() - target.m_21223_();
                    double lackedMagicule = SkillHelper.outOfMagiculeStillConsume(entity, (int)(lackedHealth * (float)cost));
                    if (lackedMagicule > 0.0) {
                        lackedHealth = (float)((double)lackedHealth - lackedMagicule / (double)cost);
                    }
                    target.m_5634_(lackedHealth);
                    boolean bl = success = success || lackedHealth > 0.0f;
                    if (success) {
                        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123749_, 1.0);
                    }
                } else {
                    success = SkillHelper.removePredicateEffect(entity, effect -> true, this.magiculeCost(entity, instance));
                    int cost = instance.isMastered(entity) ? 40 : 80;
                    float lackedHealth = entity.m_21233_() - entity.m_21223_();
                    double lackedMagicule = SkillHelper.outOfMagiculeStillConsume(entity, (int)(lackedHealth * (float)cost));
                    if (lackedMagicule > 0.0) {
                        lackedHealth = (float)((double)lackedHealth - lackedMagicule / (double)cost);
                    }
                    entity.m_5634_(lackedHealth);
                    boolean bl = success = success || lackedHealth > 0.0f;
                    if (success) {
                        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_123749_, 1.0);
                    }
                }
                if (!success) break;
                this.addMasteryPoint(skillInstance, entity);
                instance.setCoolDown(instance.isMastered(entity) ? 5 : 3);
                entity.m_21011_(InteractionHand.MAIN_HAND, true);
                level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
            case 3: {
                if (SkillHelper.outOfMagicule(entity, skillInstance)) {
                    return;
                }
                SkillHelper.comingSoonMessage(entity, (Component)Component.m_237110_((String)"tooltip.tensura.coming_soon_feature", (Object[])new Object[]{this.getModeName(3)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)));
                break;
            }
            case 4: {
                if (SkillHelper.outOfMagicule(entity, skillInstance)) {
                    return;
                }
                CompoundTag tag = skillInstance.getOrCreateTag();
                int learnPoint = tag.m_128451_("EmbracingDrain");
                if (learnPoint < 100) {
                    tag.m_128405_("EmbracingDrain", learnPoint + SkillUtils.getEarningLearnPoint(instance, entity, true));
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        if (tag.m_128451_("EmbracingDrain") >= 100) {
                            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire_learning", (Object[])new Object[]{this.getModeName(4)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                        } else {
                            instance.setCoolDown(10);
                            SkillUtils.learningFailPenalty(entity);
                            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.learn_points_added", (Object[])new Object[]{this.getModeName(4)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), true);
                        }
                        player.m_6330_(SoundEvents.f_11871_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                    skillInstance.markDirty();
                    return;
                }
                LivingEntity target = SkillHelper.getTargetingEntity(entity, 3.0, false);
                if (target == null) {
                    return;
                }
                if (target instanceof Player) {
                    Player player = (Player)target;
                    if (player.m_150110_().f_35934_) {
                        return;
                    }
                }
                if (SkillHelper.outOfMagicule(entity, skillInstance)) {
                    return;
                }
                this.addMasteryPoint(skillInstance, entity);
                int embrace = instance.isMastered(entity) ? 1 : 0;
                SkillHelper.checkThenAddEffectSource(target, (Entity)entity, (MobEffect)TensuraMobEffects.LUST_EMBRACEMENT.get(), 100, embrace);
                SkillHelper.checkThenAddEffectSource(entity, (Entity)entity, (MobEffect)TensuraMobEffects.LUST_EMBRACEMENT.get(), 100, embrace);
                level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12053_, SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
            case 5: {
                CompoundTag tag = skillInstance.getOrCreateTag();
                int learnPoint = tag.m_128451_("DeathBlessing");
                if (learnPoint >= 100) break;
                if (SkillHelper.outOfMagicule(entity, skillInstance)) {
                    return;
                }
                tag.m_128405_("DeathBlessing", learnPoint + SkillUtils.getEarningLearnPoint(instance, entity, true));
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (tag.m_128451_("DeathBlessing") >= 100) {
                        player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire_learning", (Object[])new Object[]{this.getModeName(5)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                    } else {
                        instance.setCoolDown(10);
                        SkillUtils.learningFailPenalty(entity);
                        player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.learn_points_added", (Object[])new Object[]{this.getModeName(5)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), true);
                    }
                    player.m_6330_(SoundEvents.f_11871_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                skillInstance.markDirty();
            }
        }
    }

    private void reduceStat(LivingEntity target, double amount, LivingEntity attacker) {
        if (target instanceof Player) {
            Player playerTarget = (Player)target;
            TensuraPlayerCapability.getFrom(playerTarget).ifPresent(cap -> {
                cap.setMagicule(cap.getMagicule() - amount * 0.75);
                cap.setAura(cap.getAura() - amount * 0.25);
            });
            TensuraPlayerCapability.sync(playerTarget);
        } else {
            SkillHelper.reduceEP(target, attacker, amount, false);
        }
    }
}

