/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.ISpatialStorage;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.menu.container.SpatialStorageContainer;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSource;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import org.jetbrains.annotations.NotNull;

public class InfinityPrisonSkill
extends Skill
implements ISpatialStorage {
    public InfinityPrisonSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    @Override
    public double getObtainingEpCost() {
        return 90000.0;
    }

    @Override
    public double learningCost() {
        return 10000.0;
    }

    @Override
    public int modes() {
        return 2;
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 10000.0;
    }

    @Override
    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        return instance.getMode() == 1 ? 2 : 1;
    }

    @Override
    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"tensura.skill.mode.infinity_prison.imprison");
            case 2 -> Component.m_237115_((String)"tensura.skill.mode.infinity_prison.imaginary_space");
            default -> Component.m_237119_();
        };
    }

    public boolean canIgnoreCoolDown(ManasSkillInstance instance, LivingEntity entity) {
        if (instance.getMastery() < 0) {
            return false;
        }
        return instance.getMode() != 1;
    }

    public void onBeingDamaged(ManasSkillInstance instance, LivingAttackEvent event) {
        TensuraDamageSource tensuraSource;
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (!this.isInSlot(entity)) {
            return;
        }
        DamageSource damageSource = event.getSource();
        if (damageSource.m_19378_()) {
            return;
        }
        if (damageSource instanceof TensuraDamageSource && (tensuraSource = (TensuraDamageSource)damageSource).getIgnoreBarrier() >= 2.0f) {
            return;
        }
        Entity entity2 = damageSource.m_7639_();
        if (entity2 instanceof LivingEntity) {
            LivingEntity source = (LivingEntity)entity2;
            if (TensuraEPCapability.getEP(source) >= TensuraEPCapability.getEP(entity) * 0.75) {
                return;
            }
            if (entity instanceof Player) {
                Player player = (Player)entity;
                double cost = event.getAmount() * 25.0f;
                if (TensuraPlayerCapability.getMagicule(player) < cost) {
                    return;
                }
                TensuraPlayerCapability.decreaseMagicule(player, cost);
            }
            event.setCanceled(true);
        }
    }

    public void onTakenDamage(ManasSkillInstance instance, LivingDamageEvent event) {
        TensuraDamageSource tensuraSource;
        if (event.isCanceled()) {
            return;
        }
        if (!this.isInSlot(event.getEntity())) {
            return;
        }
        DamageSource damageSource = event.getSource();
        if (damageSource.m_19378_()) {
            return;
        }
        if (damageSource instanceof TensuraDamageSource && (tensuraSource = (TensuraDamageSource)damageSource).getIgnoreBarrier() >= 2.0f) {
            return;
        }
        Entity entity = damageSource.m_7639_();
        if (entity instanceof LivingEntity) {
            TensuraDamageSource tensuraSource2;
            LivingEntity source = (LivingEntity)entity;
            if (TensuraEPCapability.getEP(source) >= TensuraEPCapability.getEP(event.getEntity()) * 0.75) {
                return;
            }
            float amount = event.getAmount();
            double lackedMana = SkillHelper.outOfMagiculeStillConsume(event.getEntity(), (int)(amount * 25.0f));
            if (lackedMana > 0.0) {
                amount = (float)((double)amount - lackedMana / 25.0);
            }
            if (damageSource instanceof TensuraDamageSource && (tensuraSource2 = (TensuraDamageSource)damageSource).getMpCost() > 0.0) {
                CompoundTag tag = instance.getOrCreateTag();
                double mp = tag.m_128459_("mpStorage") + tensuraSource2.getMpCost() * (double)amount / (double)event.getAmount();
                tag.m_128347_("mpStorage", mp);
                instance.markDirty();
            }
            if (amount < event.getAmount()) {
                event.setAmount(event.getAmount() - amount);
            } else {
                event.setCanceled(true);
            }
        }
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        if (instance.getMode() == 1) {
            LivingEntity target = SkillHelper.getTargetingEntity(LivingEntity.class, entity, 30.0, 0.2, false, true);
            if (target == null) {
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.m_5661_((Component)Component.m_237115_((String)"tensura.targeting.not_targeted").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                }
                instance.setCoolDown(instance.isMastered(entity) ? 10 : 20);
                return;
            }
            if (target.m_21023_((MobEffect)TensuraMobEffects.INFINITE_IMPRISONMENT.get())) {
                target.m_21195_((MobEffect)TensuraMobEffects.INFINITE_IMPRISONMENT.get());
                entity.m_21011_(InteractionHand.MAIN_HAND, true);
                entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 1.0f);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123747_, 1.0);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123749_, 1.0);
            } else {
                if (target instanceof Player) {
                    Player player = (Player)target;
                    if (player.m_150110_().f_35934_) {
                        return;
                    }
                }
                if (SkillHelper.outOfMagicule(entity, instance)) {
                    return;
                }
                instance.addMasteryPoint(entity);
                instance.setCoolDown(instance.isMastered(entity) ? 10 : 20);
                int duration = this.isMastered(instance, entity) ? 12000 : 6000;
                SkillHelper.checkThenAddEffectSource(target, (Entity)entity, (MobEffect)TensuraMobEffects.INFINITE_IMPRISONMENT.get(), duration, 0, false, false, false, true);
                DamageSourceHelper.markHurt(target, (Entity)entity);
                entity.m_21011_(InteractionHand.MAIN_HAND, true);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123747_, 1.0);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123813_, 1.0);
                entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12049_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        } else {
            this.openSpatialStorage(entity, instance);
        }
    }

    @Override
    @NotNull
    public SpatialStorageContainer getSpatialStorage(ManasSkillInstance instance) {
        SpatialStorageContainer container = new SpatialStorageContainer(90, 999);
        container.m_7797_(instance.getOrCreateTag().m_128437_("SpatialStorage", 10));
        return container;
    }
}

