/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2client.RequestFxSpawningPacket;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;

public class HealerSkill
extends Skill {
    public HealerSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    @Override
    public double getObtainingEpCost() {
        return 20000.0;
    }

    @Override
    public double learningCost() {
        return 3000.0;
    }

    @Override
    public int modes() {
        return 3;
    }

    @Override
    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return switch (instance.getMode()) {
                case 3 -> 2;
                case 2 -> 1;
                case 1 -> {
                    if (instance.isMastered(entity)) {
                        yield 3;
                    }
                    yield 2;
                }
                default -> 0;
            };
        }
        return switch (instance.getMode()) {
            case 2 -> {
                if (instance.isMastered(entity)) {
                    yield 3;
                }
                yield 1;
            }
            case 1 -> 2;
            default -> 1;
        };
    }

    @Override
    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"tensura.skill.mode.healer.heal");
            case 2 -> Component.m_237115_((String)"tensura.skill.mode.healer.virus");
            case 3 -> Component.m_237115_((String)"tensura.skill.mode.healer.plague");
            default -> Component.m_237119_();
        };
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 2 -> 100.0;
            case 3 -> 300.0;
            default -> 0.0;
        };
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        if (SkillHelper.outOfMagicule(entity, instance)) {
            return;
        }
        Level level = entity.m_9236_();
        switch (instance.getMode()) {
            case 1: {
                LivingEntity target = SkillHelper.getTargetingEntity(entity, 5.0, false);
                entity.m_21011_(InteractionHand.MAIN_HAND, true);
                instance.setCoolDown(instance.isMastered(entity) ? 3 : 5);
                if (target != null && entity.m_6144_()) {
                    this.addMasteryPoint(instance, entity);
                    int cost = instance.isMastered(entity) ? 40 : 80;
                    float healingHP = target.m_21233_() - target.m_21223_();
                    double lackedMana = SkillHelper.outOfMagiculeStillConsume(entity, (int)(healingHP * (float)cost));
                    if (lackedMana > 0.0) {
                        healingHP = (float)((double)healingHP - lackedMana / (double)cost);
                    }
                    target.m_5634_(healingHP);
                    if (this.isMastered(instance, entity)) {
                        double healingSpiritual = TensuraEPCapability.getSpiritualHealth(target);
                        double lackedSpiritual = target.m_21133_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get()) - healingSpiritual;
                        double lackedMP = SkillHelper.outOfMagiculeStillConsume(entity, (int)(lackedSpiritual * 60.0));
                        if (lackedMP > 0.0) {
                            lackedSpiritual -= lackedMP / 60.0;
                        }
                        TensuraEPCapability.setSpiritualHealth(target, healingSpiritual + lackedSpiritual);
                    }
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123750_, 1.0);
                    level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    break;
                }
                entity.m_21195_((MobEffect)TensuraMobEffects.INFECTION.get());
                int cost = instance.isMastered(entity) ? 40 : 80;
                float healingHP = entity.m_21233_() - entity.m_21223_();
                double lackedMana = SkillHelper.outOfMagiculeStillConsume(entity, (int)(healingHP * (float)cost));
                if (lackedMana > 0.0) {
                    healingHP = (float)((double)healingHP - lackedMana / (double)cost);
                }
                entity.m_5634_(healingHP);
                if (this.isMastered(instance, entity)) {
                    double healingSpiritual = TensuraEPCapability.getSpiritualHealth(entity);
                    double lackedSpiritual = entity.m_21133_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get()) - healingSpiritual;
                    double lackedMP = SkillHelper.outOfMagiculeStillConsume(entity, (int)(lackedSpiritual * 50.0));
                    if (lackedMP > 0.0) {
                        lackedSpiritual -= lackedMP / 50.0;
                    }
                    TensuraEPCapability.setSpiritualHealth(entity, healingSpiritual + lackedSpiritual);
                }
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_123750_, 1.0);
                level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
            case 2: {
                LivingEntity target = SkillHelper.getTargetingEntity(entity, 5.0, false);
                entity.m_21011_(InteractionHand.MAIN_HAND, true);
                if (target == null) break;
                this.addMasteryPoint(instance, entity);
                if (target.m_21023_((MobEffect)TensuraMobEffects.INFECTION.get())) {
                    target.m_21195_((MobEffect)TensuraMobEffects.INFECTION.get());
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123749_, 1.0);
                    level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    break;
                }
                if (target instanceof Player) {
                    Player player = (Player)target;
                    if (player.m_150110_().f_35934_) {
                        return;
                    }
                }
                instance.setCoolDown(instance.isMastered(entity) ? 3 : 1);
                SkillHelper.checkThenAddEffectSource(target, (Entity)entity, new MobEffectInstance((MobEffect)TensuraMobEffects.INFECTION.get(), 900, 0));
                DamageSourceHelper.markHurt(target, (Entity)entity);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123784_, 1.0);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123784_, 2.0);
                level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_215734_, SoundSource.PLAYERS, 10.0f, 1.0f);
            }
        }
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity living, int heldTicks) {
        List list;
        if (instance.getMode() != 3) {
            return false;
        }
        if (heldTicks % 20 == 0 && SkillHelper.outOfMagicule(living, instance)) {
            return false;
        }
        if (heldTicks % 60 == 0 && heldTicks > 0) {
            this.addMasteryPoint(instance, living);
        }
        Level level = living.m_9236_();
        level.m_6263_(null, living.m_20185_(), living.m_20186_(), living.m_20189_(), SoundEvents.f_215734_, SoundSource.PLAYERS, 10.0f, 1.0f);
        if (heldTicks % 10 == 0) {
            TensuraNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> living), (Object)new RequestFxSpawningPacket(new ResourceLocation("tensura:healer_plague"), living.m_19879_(), 0.0, 1.0, 0.0, true));
        }
        if (!(list = level.m_6443_(LivingEntity.class, living.m_20191_().m_82400_(7.0), entity -> !entity.m_7306_((Entity)living) && entity.m_6084_() && !entity.m_7307_((Entity)living))).isEmpty()) {
            for (LivingEntity target : list) {
                if (target instanceof Player) {
                    Player player = (Player)target;
                    if (player.m_150110_().f_35934_) continue;
                }
                SkillHelper.checkThenAddEffectSource(target, (Entity)living, new MobEffectInstance((MobEffect)TensuraMobEffects.INFECTION.get(), 900, 0));
            }
        }
        return true;
    }
}

