/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSource;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class GuardianSkill
extends Skill {
    protected static final UUID GUARDIAN = UUID.fromString("84eceda2-570c-11ee-8c99-0242ac120002");

    public GuardianSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    @Override
    public double getObtainingEpCost() {
        return 20000.0;
    }

    @Override
    public double learningCost() {
        return 100.0;
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return true;
    }

    @Override
    public int modes() {
        return 2;
    }

    @Override
    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        return instance.getMode() == 1 ? 2 : 1;
    }

    @Override
    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"tensura.skill.mode.guardian.grant");
            case 2 -> Component.m_237115_((String)"tensura.skill.mode.guardian.iron_wall");
            default -> Component.m_237119_();
        };
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 100.0;
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        if (SkillHelper.outOfMagicule(entity, instance)) {
            return;
        }
        Level level = entity.m_9236_();
        switch (instance.getMode()) {
            case 1: {
                entity.m_21011_(InteractionHand.MAIN_HAND, true);
                level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11671_, SoundSource.PLAYERS, 1.0f, 1.0f);
                List list = level.m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(25.0), living -> !entity.m_7306_((Entity)living) && living.m_6084_() && living.m_7307_((Entity)entity));
                if (list.isEmpty()) {
                    return;
                }
                this.addMasteryPoint(instance, entity);
                for (LivingEntity target : list) {
                    target.m_147207_(new MobEffectInstance((MobEffect)TensuraMobEffects.PROTECTION.get(), 3600, 0, false, false, true), (Entity)entity);
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_175828_, 1.0);
                }
                break;
            }
            case 2: {
                entity.m_21011_(InteractionHand.MAIN_HAND, true);
                AttributeInstance armor = entity.m_21051_(Attributes.f_22284_);
                if (armor == null || armor.m_22111_(GUARDIAN) == null) {
                    if (armor != null) {
                        float amount = instance.isMastered(entity) ? 40.0f : 15.0f;
                        AttributeModifier modifier = new AttributeModifier(GUARDIAN, "Guardian", (double)amount, AttributeModifier.Operation.ADDITION);
                        armor.m_22125_(modifier);
                    }
                    AttributeInstance knockBack = entity.m_21051_(Attributes.f_22278_);
                    float knockAmount = instance.isMastered(entity) ? 1.0f : 0.4f;
                    AttributeModifier attributemodifier = new AttributeModifier(GUARDIAN, "Guardian", (double)knockAmount, AttributeModifier.Operation.ADDITION);
                    if (knockBack != null && !knockBack.m_22109_(attributemodifier)) {
                        knockBack.m_22125_(attributemodifier);
                    }
                    level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11671_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    break;
                }
                armor.m_22127_(GUARDIAN);
                AttributeInstance attributeInstance = entity.m_21051_(Attributes.f_22278_);
                if (attributeInstance != null) {
                    attributeInstance.m_22127_(GUARDIAN);
                }
                level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11665_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    public void onToggleOff(ManasSkillInstance instance, LivingEntity entity) {
        AttributeInstance attributeInstance;
        AttributeInstance armor = entity.m_21051_(Attributes.f_22284_);
        if (armor != null) {
            armor.m_22127_(GUARDIAN);
        }
        if ((attributeInstance = entity.m_21051_(Attributes.f_22278_)) != null) {
            attributeInstance.m_22127_(GUARDIAN);
        }
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11665_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public static boolean onSubordinateHurt(LivingHurtEvent event) {
        TensuraDamageSource source;
        LivingEntity entity = event.getEntity();
        if (event.getSource().m_19378_()) {
            return false;
        }
        DamageSource damageSource = event.getSource();
        if (damageSource instanceof TensuraDamageSource && (double)(source = (TensuraDamageSource)damageSource).getIgnoreBarrier() >= 1.5) {
            return false;
        }
        damageSource = SkillHelper.getSubordinateOwner(entity);
        if (!(damageSource instanceof Player)) {
            return false;
        }
        Player player = (Player)damageSource;
        if (event.getSource().m_7639_() == player) {
            return false;
        }
        if (GuardianSkill.isGuardianToggled((LivingEntity)player)) {
            player.m_6469_((DamageSource)DamageSourceHelper.turnTensura(event.getSource()).setNoKnock(), event.getAmount());
            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.guardian.substitution_notification", (Object[])new Object[]{Float.valueOf(event.getAmount()), entity.m_7755_()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), true);
            event.setCanceled(true);
            return true;
        }
        return false;
    }

    public static boolean isGuardianToggled(LivingEntity player) {
        return SkillAPI.getSkillsFrom((Entity)player).getSkill((ManasSkill)UniqueSkills.GUARDIAN.get()).map(ManasSkillInstance::isToggled).orElse(false);
    }
}

