/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.intrinsic.CharmSkill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.entity.template.TensuraHorseEntity;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import com.github.manasmods.tensura.world.TensuraGameRules;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class GreedSkill
extends Skill {
    protected static final UUID GREED = UUID.fromString("b75a5836-984a-11ee-b9d1-0242ac120002");

    public GreedSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    @Override
    public double getObtainingEpCost() {
        return 100000.0;
    }

    @Override
    public int getMaxMastery() {
        return 1500;
    }

    @Override
    public int modes() {
        return 3;
    }

    @Override
    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return instance.getMode() == 1 ? 3 : instance.getMode() - 1;
        }
        return instance.getMode() == 3 ? 1 : instance.getMode() + 1;
    }

    @Override
    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"tensura.skill.mode.greed.spiritual");
            case 2 -> Component.m_237115_((String)"tensura.skill.mode.greed.flare");
            case 3 -> Component.m_237115_((String)"tensura.skill.mode.greed.death");
            default -> Component.m_237119_();
        };
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        if (instance.getMode() == 3) {
            return 1000.0;
        }
        return 0.0;
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        CompoundTag tag = instance.getOrCreateTag();
        if (!tag.m_128441_("target") && tag.m_128451_("heldSeconds") == 0) {
            return false;
        }
        return !this.isHeld(entity);
    }

    public void onTick(ManasSkillInstance instance, LivingEntity entity) {
        CompoundTag tag = instance.getOrCreateTag();
        tag.m_128473_("target");
        tag.m_128405_("heldSeconds", 0);
        tag.m_128405_("targetDesire", 0);
    }

    public void onDamageEntity(ManasSkillInstance instance, LivingEntity attacker, LivingHurtEvent e) {
        AttributeInstance attack = attacker.m_21051_(Attributes.f_22281_);
        if (attack == null) {
            return;
        }
        AttributeModifier modifier = attack.m_22111_(GREED);
        if (modifier == null) {
            return;
        }
        DamageSource source = e.getSource();
        if (source.m_7639_() != attacker) {
            return;
        }
        if (!DamageSourceHelper.isPhysicalAttack(source)) {
            return;
        }
        if (SkillHelper.outOfMagicule(attacker, modifier.m_22218_() * 10.0)) {
            attack.m_22127_(GREED);
        }
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        Level level = entity.m_9236_();
        switch (instance.getMode()) {
            case 1: {
                if (entity.m_6144_()) {
                    return false;
                }
                CompoundTag tag = instance.getOrCreateTag();
                int second = tag.m_128451_("heldSeconds");
                LivingEntity target = SkillHelper.getTargetingEntity(LivingEntity.class, entity, 30.0, 0.5, true, true);
                if (target != null && (!tag.m_128441_("target") || Objects.equals(tag.m_128342_("target"), target.m_20148_()))) {
                    if (!CharmSkill.canMindControl(target, level) && entity instanceof Player) {
                        Player player = (Player)entity;
                        player.m_5661_((Component)Component.m_237115_((String)"tensura.ability.activation_failed").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                        return false;
                    }
                    if (heldTicks % 100 == 0 && heldTicks > 0) {
                        this.addMasteryPoint(instance, entity);
                    }
                    int controlling = target instanceof Player ? 60 : 90;
                    double distance = target.m_20270_((Entity)entity);
                    if (distance < 5.0) {
                        controlling -= 30;
                    }
                    if (distance > 20.0) {
                        controlling += 30;
                    }
                    if (heldTicks % 20 == 0) {
                        tag.m_128405_("heldSeconds", second + 1);
                    }
                    int desire = tag.m_128451_("targetDesire");
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.time_held.max", (Object[])new Object[]{second, controlling - desire}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), true);
                        player.m_6330_(SoundEvents.f_11867_, SoundSource.PLAYERS, 0.2f, 1.0f);
                    }
                    if (second < controlling - desire) break;
                    TensuraEPCapability.getFrom(target).ifPresent(cap -> {
                        if (!Objects.equals(cap.getTemporaryOwner(), entity.m_20148_())) {
                            cap.setTemporaryOwner(entity.m_20148_());
                            if (entity instanceof Player) {
                                Player player = (Player)entity;
                                if (target instanceof TamableAnimal) {
                                    TamableAnimal animal = (TamableAnimal)target;
                                    animal.m_21828_(player);
                                } else if (target instanceof TensuraHorseEntity) {
                                    TensuraHorseEntity horse = (TensuraHorseEntity)target;
                                    horse.m_30637_(player);
                                }
                            }
                            TensuraEPCapability.sync(target);
                            entity.m_21011_(InteractionHand.MAIN_HAND, true);
                            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123750_);
                            level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 0.5f, 1.0f);
                        }
                    });
                    tag.m_128405_("targetDesire", 0);
                    tag.m_128405_("heldSeconds", 0);
                    tag.m_128473_("target");
                    break;
                }
                if (heldTicks % 20 != 0) break;
                tag.m_128405_("heldSeconds", Math.max(0, second - 1));
                if (tag.m_128451_("heldSeconds") <= 0) {
                    tag.m_128473_("target");
                }
                if (!(entity instanceof Player)) break;
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.time_held", (Object[])new Object[]{second}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), true);
                break;
            }
            case 3: {
                CompoundTag tag = instance.getOrCreateTag();
                int second = tag.m_128451_("heldSeconds");
                LivingEntity target = SkillHelper.getTargetingEntity(LivingEntity.class, entity, 5.0, 0.5, true, true);
                if (target != null && (!tag.m_128441_("target") || Objects.equals(tag.m_128342_("target"), target.m_20148_()))) {
                    Player player;
                    if (target instanceof Player) {
                        player = (Player)target;
                        if (player.m_150110_().f_35934_) {
                            return false;
                        }
                    }
                    if (heldTicks % 20 == 0) {
                        tag.m_128405_("heldSeconds", second + 1);
                    }
                    if (entity instanceof ServerPlayer) {
                        player = (ServerPlayer)entity;
                        player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.time_held.max", (Object[])new Object[]{second, 10}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), true);
                        TensuraParticleHelper.addServerParticlesAroundSelfToOnePlayer((ServerPlayer)player, (Entity)target, (ParticleOptions)ParticleTypes.f_123790_, 1.0);
                    }
                    if (second < 10) break;
                    tag.m_128405_("heldSeconds", 0);
                    tag.m_128473_("target");
                    if (SkillHelper.outOfMagicule(entity, instance)) {
                        return false;
                    }
                    this.addMasteryPoint(instance, entity);
                    if (!target.m_6469_((DamageSource)this.sourceWithMP(TensuraDamageSources.deathWish((Entity)entity), entity, instance), target.m_21233_() * 10.0f)) break;
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123765_);
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123808_);
                    return false;
                }
                if (heldTicks % 20 != 0) break;
                tag.m_128405_("heldSeconds", Math.max(0, second - 1));
                if (tag.m_128451_("heldSeconds") <= 0) {
                    tag.m_128473_("target");
                }
                if (!(entity instanceof Player)) break;
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.time_held", (Object[])new Object[]{second}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), true);
            }
        }
        return true;
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        Level level = entity.m_9236_();
        CompoundTag tag = instance.getOrCreateTag();
        switch (instance.getMode()) {
            case 1: {
                LivingEntity target = SkillHelper.getTargetingEntity(entity, 30.0, false);
                if (target == null) {
                    return;
                }
                UUID uuid = entity.m_20148_();
                if (entity.m_6144_()) {
                    TensuraEPCapability.getFrom(target).ifPresent(cap -> {
                        if (Objects.equals(cap.getTemporaryOwner(), uuid)) {
                            cap.setTemporaryOwner(null);
                            UUID owner = cap.getPermanentOwner();
                            if (target instanceof TensuraTamableEntity) {
                                TensuraTamableEntity tamable = (TensuraTamableEntity)target;
                                tamable.resetOwner(owner);
                            } else if (target instanceof TensuraHorseEntity) {
                                TensuraHorseEntity horse = (TensuraHorseEntity)target;
                                horse.resetOwner(owner);
                            } else if (target instanceof TamableAnimal) {
                                TamableAnimal animal = (TamableAnimal)target;
                                animal.m_21816_(owner);
                                if (owner == null) {
                                    animal.m_7105_(false);
                                }
                            }
                            SkillHelper.setWander(target);
                            level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 1.0f, 1.0f);
                            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123792_);
                            TensuraEPCapability.sync(target);
                            entity.m_21011_(InteractionHand.MAIN_HAND, true);
                        }
                    });
                    return;
                }
                if (target instanceof Player) {
                    Player player = (Player)target;
                    if (player.m_150110_().f_35934_) {
                        return;
                    }
                }
                if (target.m_7307_((Entity)entity)) {
                    return;
                }
                if (target instanceof Player && TensuraGameRules.noPlayerMindControl(level)) {
                    return;
                }
                int desire = 0;
                if (target instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)target;
                    desire = player.m_8951_().m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_12941_)) / 10;
                }
                tag.m_128405_("targetDesire", desire);
                tag.m_128362_("target", target.m_20148_());
                tag.m_128405_("heldSeconds", 0);
                break;
            }
            case 2: {
                LivingEntity target = SkillHelper.getTargetingEntity(entity, 20.0, false);
                if (target != null && target.m_6084_()) {
                    Race race;
                    if (target.m_7307_((Entity)entity)) {
                        Race race2 = TensuraPlayerCapability.getRace(target);
                        double multiplier = race2 == null ? 2.0 : race2.getSpiritualHealthMultiplier();
                        double boost = TensuraEPCapability.getSpiritualHealth(target) / multiplier / 10.0;
                        if (SkillHelper.outOfMagicule(entity, boost * 20.0)) {
                            return;
                        }
                        AttributeInstance attack = target.m_21051_(Attributes.f_22281_);
                        if (attack == null) {
                            return;
                        }
                        AttributeModifier modifier = attack.m_22111_(GREED);
                        if (modifier != null) {
                            attack.m_22127_(GREED);
                            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_175828_);
                            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11738_, SoundSource.PLAYERS, 1.0f, 1.0f);
                            break;
                        }
                        AttributeModifier attackModifier = new AttributeModifier(GREED, "Greed Attack", boost, AttributeModifier.Operation.ADDITION);
                        attack.m_22125_(attackModifier);
                        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_175829_);
                        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11736_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        break;
                    }
                    if (target instanceof Player) {
                        Player player = (Player)target;
                        if (player.m_150110_().f_35934_) {
                            return;
                        }
                    }
                    double multiplier = (race = TensuraPlayerCapability.getRace(entity)) == null ? 2.0 : race.getSpiritualHealthMultiplier();
                    double damage = TensuraEPCapability.getSpiritualHealth(entity) / multiplier / 10.0;
                    if (SkillHelper.outOfMagicule(entity, damage * 20.0)) {
                        return;
                    }
                    if (!target.m_6469_((DamageSource)this.sourceWithMP(TensuraDamageSources.deathWish((Entity)entity), entity, instance), (float)damage)) break;
                    this.addMasteryPoint(instance, entity);
                    instance.setCoolDown(120);
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123765_);
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123808_);
                    break;
                }
                Race race = TensuraPlayerCapability.getRace(entity);
                double multiplier = race == null ? 2.0 : race.getSpiritualHealthMultiplier();
                double boost = TensuraEPCapability.getSpiritualHealth(entity) / multiplier / 5.0;
                if (SkillHelper.outOfMagicule(entity, boost * 10.0)) {
                    return;
                }
                AttributeInstance attack = entity.m_21051_(Attributes.f_22281_);
                if (attack == null) {
                    return;
                }
                AttributeModifier modifier = attack.m_22111_(GREED);
                if (modifier != null) {
                    attack.m_22127_(GREED);
                    entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11738_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    break;
                }
                AttributeModifier attackModifier = new AttributeModifier(GREED, "Greed Attack", boost, AttributeModifier.Operation.ADDITION);
                attack.m_22125_(attackModifier);
                entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11736_, SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
            case 3: {
                LivingEntity target = SkillHelper.getTargetingEntity(entity, 30.0, false);
                if (target == null) {
                    return;
                }
                if (target instanceof Player) {
                    Player player = (Player)target;
                    if (player.m_150110_().f_35934_) {
                        return;
                    }
                }
                if (target.m_7307_((Entity)entity)) {
                    return;
                }
                if (target instanceof Player && TensuraGameRules.noPlayerMindControl(level)) {
                    return;
                }
                tag.m_128362_("target", target.m_20148_());
                tag.m_128405_("heldSeconds", 0);
            }
        }
    }

    public void onToggleOff(ManasSkillInstance instance, LivingEntity entity) {
        AttributeModifier modifier;
        AttributeInstance attack = entity.m_21051_(Attributes.f_22281_);
        if (attack != null && (modifier = attack.m_22111_(GREED)) != null) {
            attack.m_22127_(GREED);
        }
        CompoundTag tag = instance.getOrCreateTag();
        tag.m_128405_("targetDesire", 0);
        tag.m_128473_("target");
        tag.m_128405_("heldSeconds", 0);
    }

    public void onRelease(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        CompoundTag tag = instance.getOrCreateTag();
        tag.m_128405_("targetDesire", 0);
        tag.m_128473_("target");
        tag.m_128405_("heldSeconds", 0);
    }
}

