/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.ISpatialStorage;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.extra.ThoughtAccelerationSkill;
import com.github.manasmods.tensura.capability.skill.TensuraSkillCapability;
import com.github.manasmods.tensura.event.SkillPlunderEvent;
import com.github.manasmods.tensura.menu.GreatSageCraftingMenu;
import com.github.manasmods.tensura.menu.GreatSageRefiningMenu;
import com.github.manasmods.tensura.menu.container.SpatialStorageContainer;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2client.ClientboundSpatialStorageOpenPacket;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class GreatSageSkill
extends Skill
implements ISpatialStorage {
    protected static final UUID ACCELERATION = UUID.fromString("753d7401-7c9c-49de-ad16-6b2b6e1e9342");

    public GreatSageSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    @Override
    public double getObtainingEpCost() {
        return 75000.0;
    }

    @Override
    public double learningCost() {
        return 10000.0;
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return true;
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        return true;
    }

    @Override
    protected boolean canActivateInRaceLimit(ManasSkillInstance instance) {
        return instance.getMode() == 1;
    }

    @Override
    public int modes() {
        return 2;
    }

    @Override
    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        return instance.getMode() == 1 ? 2 : 1;
    }

    @Override
    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"tensura.skill.mode.great_sage.analytical_appraisal");
            case 2 -> Component.m_237115_((String)"tensura.skill.mode.great_sage.analysis");
            default -> Component.m_237119_();
        };
    }

    public void onToggleOn(ManasSkillInstance instance, LivingEntity entity) {
        ThoughtAccelerationSkill.onToggle(instance, entity, ACCELERATION, true);
    }

    public void onToggleOff(ManasSkillInstance instance, LivingEntity entity) {
        ThoughtAccelerationSkill.onToggle(instance, entity, ACCELERATION, false);
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        block9: {
            List<ManasSkillInstance> collection;
            LivingEntity target;
            block10: {
                if (instance.getMode() == 1) {
                    if (!(entity instanceof Player)) {
                        return;
                    }
                    Player player = (Player)entity;
                    TensuraSkillCapability.getFrom(player).ifPresent(cap -> {
                        int level;
                        if (player.m_6047_()) {
                            int mode = cap.getAnalysisMode();
                            switch (mode) {
                                case 1: {
                                    cap.setAnalysisMode(2);
                                    player.m_5661_((Component)Component.m_237115_((String)"tensura.skill.analytical.analyzing_mode.block").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA)), true);
                                    break;
                                }
                                case 2: {
                                    cap.setAnalysisMode(0);
                                    player.m_5661_((Component)Component.m_237115_((String)"tensura.skill.analytical.analyzing_mode.both").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA)), true);
                                    break;
                                }
                                default: {
                                    cap.setAnalysisMode(1);
                                    player.m_5661_((Component)Component.m_237115_((String)"tensura.skill.analytical.analyzing_mode.entity").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA)), true);
                                }
                            }
                            player.m_6330_(SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
                            TensuraSkillCapability.sync(player);
                            return;
                        }
                        int n = level = instance.isMastered(entity) ? 18 : 8;
                        if (cap.getAnalysisLevel() != level) {
                            cap.setAnalysisLevel(level);
                            cap.setAnalysisDistance(instance.isMastered(entity) ? 30 : 20);
                            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        } else {
                            cap.setAnalysisLevel(0);
                            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        }
                        TensuraSkillCapability.sync(player);
                    });
                    return;
                }
                target = SkillHelper.getTargetingEntity(entity, 10.0, false);
                if (target == null || !target.m_6084_()) break block9;
                if (!(target instanceof Player)) break block10;
                Player player = (Player)target;
                if (player.m_150110_().f_35934_) break block9;
            }
            entity.m_21011_(InteractionHand.MAIN_HAND, true);
            ServerLevel level = (ServerLevel)entity.m_9236_();
            int chance = instance.isMastered(entity) ? 50 : 25;
            boolean failed = true;
            if (entity.m_217043_().m_188503_(100) <= chance && !(collection = SkillAPI.getSkillsFrom((Entity)target).getLearnedSkills().stream().filter(this::canCopy).toList()).isEmpty()) {
                this.addMasteryPoint(instance, entity);
                ManasSkill skill = collection.get(target.m_217043_().m_188503_(collection.size())).getSkill();
                SkillPlunderEvent event = new SkillPlunderEvent((Entity)target, (Entity)entity, false, skill);
                if (!MinecraftForge.EVENT_BUS.post((Event)event) && SkillUtils.learnSkill(entity, event.getSkill(), instance.getRemoveTime())) {
                    instance.setCoolDown(10);
                    failed = false;
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire", (Object[])new Object[]{event.getSkill().getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                    }
                    level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
            if (failed && entity instanceof Player) {
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237115_((String)"tensura.ability.activation_failed").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 1.0f, 1.0f);
                instance.setCoolDown(5);
            }
            return;
        }
        this.openSpatialStorage(entity, instance);
    }

    @Override
    public void openSpatialStorage(LivingEntity entity, ManasSkillInstance instance) {
        GreatSageSkill.openGreatSageGUI(entity, instance, entity.m_6144_() ? 2 : 1);
    }

    public static void openGreatSageGUI(LivingEntity entity, ManasSkillInstance instance, int type) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.f_36096_.m_6877_((Player)player);
            player.m_9217_();
            player.m_6330_(SoundEvents.f_11889_, SoundSource.PLAYERS, 1.0f, 1.0f);
            ManasSkill skill = instance.getSkill();
            SpatialStorageContainer container = ((ISpatialStorage)instance.getSkill()).getSpatialStorage(instance);
            TensuraNetwork.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientboundSpatialStorageOpenPacket(player.m_19879_(), player.f_8940_, container.m_6643_(), container.m_6893_(), SkillUtils.getSkillId(skill), (byte)type));
            player.f_36096_ = type == 2 ? new GreatSageRefiningMenu(player.f_8940_, player.m_150109_(), (Player)player, container, skill, ContainerLevelAccess.m_39289_((Level)player.f_19853_, (BlockPos)player.m_20183_())) : new GreatSageCraftingMenu(player.f_8940_, player.m_150109_(), (Player)player, container, skill, ContainerLevelAccess.m_39289_((Level)player.f_19853_, (BlockPos)player.m_20183_()));
            player.m_143399_(player.f_36096_);
            MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((Player)player, player.f_36096_));
        }
    }

    public void onTick(ManasSkillInstance instance, LivingEntity entity) {
        AbstractContainerMenu abstractContainerMenu;
        CompoundTag tag = instance.getOrCreateTag();
        if (instance.isToggled()) {
            this.gainMastery(instance, entity);
        }
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (tag.m_128471_("Repeating")) {
            abstractContainerMenu = player.f_36096_;
            if (abstractContainerMenu instanceof GreatSageCraftingMenu) {
                GreatSageCraftingMenu craftingMenu = (GreatSageCraftingMenu)abstractContainerMenu;
                if (GreatSageCraftingMenu.autoCrafting(craftingMenu, player.f_19853_, player, craftingMenu.craftingContainer, craftingMenu.resultContainer)) {
                    this.gainMastery(instance, entity);
                    player.m_6330_(SoundEvents.f_12574_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            } else if (GreatSageCraftingMenu.autoCrafting(player.f_19853_, player, instance, this.getSpatialStorage(instance))) {
                this.gainMastery(instance, entity);
            }
        }
        if (tag.m_128471_("Brewing")) {
            abstractContainerMenu = player.f_36096_;
            if (abstractContainerMenu instanceof GreatSageRefiningMenu) {
                GreatSageRefiningMenu menu = (GreatSageRefiningMenu)abstractContainerMenu;
                if (GreatSageRefiningMenu.autoRefining(menu, player.f_19853_, player, menu.brewingContainer, menu.resultContainer)) {
                    this.gainMastery(instance, entity);
                    player.m_6330_(SoundEvents.f_12566_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            } else if (GreatSageRefiningMenu.autoRefining(player.f_19853_, player, instance, this.getSpatialStorage(instance))) {
                this.gainMastery(instance, entity);
            }
            if (!tag.m_128471_("RepeatBrewing")) {
                tag.m_128379_("Brewing", false);
                instance.markDirty();
            }
        }
    }

    @Override
    @NotNull
    public SpatialStorageContainer getSpatialStorage(ManasSkillInstance instance) {
        SpatialStorageContainer container = new SpatialStorageContainer(20, 128);
        container.m_7797_(instance.getOrCreateTag().m_128437_("SpatialStorage", 10));
        return container;
    }

    private void gainMastery(ManasSkillInstance instance, LivingEntity entity) {
        CompoundTag tag = instance.getOrCreateTag();
        int time = tag.m_128451_("activatedTimes");
        if (time % 12 == 0) {
            this.addMasteryPoint(instance, entity);
        }
        tag.m_128405_("activatedTimes", time + 1);
    }

    public boolean canCopy(ManasSkillInstance instance) {
        if (instance.isTemporarySkill() || instance.getMastery() < 0) {
            return false;
        }
        ManasSkill manasSkill = instance.getSkill();
        if (manasSkill instanceof Skill) {
            Skill skill = (Skill)manasSkill;
            return skill.getType().equals((Object)Skill.SkillType.COMMON) || skill.getType().equals((Object)Skill.SkillType.EXTRA) || skill.getType().equals((Object)Skill.SkillType.INTRINSIC);
        }
        return false;
    }
}

