/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.ISpatialStorage;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.intrinsic.AbsorbDissolveSkill;
import com.github.manasmods.tensura.ability.skill.unique.StarvedSkill;
import com.github.manasmods.tensura.capability.effects.TensuraEffectsCapability;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.entity.magic.breath.BreathEntity;
import com.github.manasmods.tensura.entity.magic.breath.PredatorMistProjectile;
import com.github.manasmods.tensura.event.SkillPlunderEvent;
import com.github.manasmods.tensura.menu.container.SpatialStorageContainer;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2client.RequestFxSpawningPacket;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.items.TensuraMaterialItems;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import com.github.manasmods.tensura.util.TensuraAdvancementsHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import com.github.manasmods.tensura.world.TensuraGameRules;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class GluttonySkill
extends Skill
implements ISpatialStorage {
    private static final String CORROSION = "8c4fec2d-6913-435e-9bfd-a111b8eadf62";

    public GluttonySkill() {
        super(Skill.SkillType.UNIQUE);
        this.addHeldAttributeModifier(Attributes.f_22279_, CORROSION, -0.5, AttributeModifier.Operation.MULTIPLY_TOTAL);
    }

    @Override
    public double getObtainingEpCost() {
        return 100000.0;
    }

    @Override
    public boolean meetEPRequirement(Player entity, double newEP) {
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        if (storage.getSkill((ManasSkill)UniqueSkills.STARVED.get()).isEmpty()) {
            return false;
        }
        return storage.getSkill((ManasSkill)UniqueSkills.PREDATOR.get()).map(instance -> instance.isMastered((LivingEntity)entity)).orElse(false);
    }

    @Override
    public int getMasteryOnEPAcquirement(Player entity) {
        return 0;
    }

    @Override
    public int getMaxMastery() {
        return 1500;
    }

    @Override
    public double learningCost() {
        return 2000.0;
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity entity) {
        return true;
    }

    @Override
    public int modes() {
        return 7;
    }

    @Override
    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return instance.getMode() == 1 ? 7 : instance.getMode() - 1;
        }
        return instance.getMode() == 7 ? 1 : instance.getMode() + 1;
    }

    @Override
    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"tensura.skill.mode.predator.predation");
            case 2 -> Component.m_237115_((String)"tensura.skill.mode.predator.stomach");
            case 3 -> Component.m_237115_((String)"tensura.skill.mode.predator.mimicry");
            case 4 -> Component.m_237115_((String)"tensura.skill.mode.predator.isolation");
            case 5 -> Component.m_237115_((String)"tensura.skill.mode.starved.corrosion");
            case 6 -> Component.m_237115_((String)"tensura.skill.mode.starved.receive");
            case 7 -> Component.m_237115_((String)"tensura.skill.mode.starved.provide");
            default -> Component.m_237119_();
        };
    }

    public boolean canIgnoreCoolDown(ManasSkillInstance instance, LivingEntity entity) {
        return instance.getMode() == 1 && entity.m_6144_();
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 5 -> 200.0;
            case 4 -> 100.0;
            default -> 0.0;
        };
    }

    public void addHeldAttributeModifiers(ManasSkillInstance instance, LivingEntity entity) {
        if (instance.getMode() != 5) {
            return;
        }
        super.addHeldAttributeModifiers(instance, entity);
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (instance.onCoolDown()) {
            return false;
        }
        switch (instance.getMode()) {
            case 1: {
                if (entity.m_6144_()) {
                    return false;
                }
                CompoundTag tag = instance.getOrCreateTag();
                if (tag.m_128459_("range") < 3.0) {
                    tag.m_128347_("range", 10.0);
                }
                if (heldTicks % 60 == 0 && heldTicks > 0) {
                    this.addMasteryPoint(instance, entity);
                }
                BreathEntity.spawnPredationMist((EntityType<? extends PredatorMistProjectile>)((EntityType)TensuraEntityTypes.GLUTTONY_MIST.get()), entity, instance, this.magiculeCost(entity, instance), (float)tag.m_128459_("range"), tag.m_128451_("blockMode"), true);
                entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11705_, SoundSource.PLAYERS, 1.0f, 1.0f);
                return true;
            }
            case 5: {
                return this.corrosion(instance, entity, heldTicks);
            }
        }
        return false;
    }

    public void onScroll(ManasSkillInstance instance, LivingEntity entity, double delta) {
        int maxRange;
        if (instance.getMode() != 1) {
            return;
        }
        CompoundTag tag = instance.getOrCreateTag();
        double newRange = tag.m_128459_("range") + delta;
        int n = maxRange = instance.isMastered(entity) ? 15 : 10;
        if (newRange > (double)maxRange) {
            newRange = 3.0;
        } else if (newRange < 3.0) {
            newRange = maxRange;
        }
        if (tag.m_128459_("range") != newRange) {
            tag.m_128347_("range", newRange);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.range", (Object[])new Object[]{newRange}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA)), true);
            }
            instance.markDirty();
        }
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        Level level = entity.m_9236_();
        CompoundTag tag = instance.getOrCreateTag();
        switch (instance.getMode()) {
            case 1: {
                instance.getOrCreateTag().m_128405_("BreathEntity", 0);
                if (entity.m_6144_() && entity instanceof Player) {
                    int newMode;
                    Player player = (Player)entity;
                    switch (tag.m_128451_("blockMode")) {
                        case 1: {
                            newMode = 2;
                            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.predator.block_mode.blocks", (Object[])new Object[]{this.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA)), true);
                            break;
                        }
                        case 2: {
                            newMode = 3;
                            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.predator.block_mode.fluid", (Object[])new Object[]{this.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA)), true);
                            break;
                        }
                        case 3: {
                            newMode = 4;
                            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.predator.block_mode.all", (Object[])new Object[]{this.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA)), true);
                            break;
                        }
                        default: {
                            newMode = 1;
                            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.predator.block_mode.none", (Object[])new Object[]{this.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA)), true);
                        }
                    }
                    tag.m_128405_("blockMode", newMode);
                }
                instance.markDirty();
                break;
            }
            case 2: {
                this.openSpatialStorage(entity, instance);
                break;
            }
            case 3: {
                SkillHelper.comingSoonMessage(entity, "Mimicry");
                break;
            }
            case 4: {
                ItemStack itemStack = entity.m_21205_();
                entity.m_21011_(InteractionHand.MAIN_HAND, true);
                if (itemStack.m_41619_()) {
                    boolean success;
                    LivingEntity target = SkillHelper.getTargetingEntity(entity, 3.0, false);
                    if (target != null) {
                        success = TensuraEffectsCapability.getSeverance(target) > 0.0;
                        TensuraEffectsCapability.getFrom(target).ifPresent(cap -> cap.setSeveranceAmount(0.0));
                        Predicate<MobEffect> predicate = effect -> effect.m_19483_() == MobEffectCategory.HARMFUL;
                        boolean bl = success = success || SkillHelper.removePredicateEffect(target, predicate, this.magiculeCost(entity, instance));
                        if (success) {
                            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123749_, 2.0);
                        }
                    } else {
                        success = TensuraEffectsCapability.getSeverance(entity) > 0.0;
                        TensuraEffectsCapability.getFrom(entity).ifPresent(cap -> cap.setSeveranceAmount(0.0));
                        Predicate<MobEffect> predicate = effect -> effect.m_19483_() == MobEffectCategory.HARMFUL;
                        boolean bl = success = success || SkillHelper.removePredicateEffect(entity, predicate, this.magiculeCost(entity, instance));
                        if (success) {
                            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_123749_, 2.0);
                        }
                    }
                    if (!success) break;
                    instance.setCoolDown(instance.isMastered(entity) ? 5 : 3);
                    level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    break;
                }
                for (AbsorbDissolveSkill.Dissolving dissolving : AbsorbDissolveSkill.Dissolving.values()) {
                    if (!dissolving.getItem().equals(itemStack.m_41720_())) continue;
                    itemStack.m_41774_(1);
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)entity;
                        if (itemStack.m_41720_().equals(TensuraMaterialItems.SLIME_IN_A_BUCKET.get())) {
                            TensuraAdvancementsHelper.grant(serverPlayer, TensuraAdvancementsHelper.Advancements.TRAITOR);
                        }
                        serverPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)itemStack.m_41720_()));
                    }
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        TensuraPlayerCapability.getFrom(player).ifPresent(cap -> {
                            double magicule = cap.getMagicule();
                            double max = player.m_21133_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get());
                            double newMagicule = magicule + (double)(dissolving.getMagicule() * 2);
                            cap.setMagicule(magicule > max ? newMagicule : Math.min(max, newMagicule));
                        });
                    }
                    if (dissolving.getHeal() > 0.0f) {
                        entity.m_5634_(dissolving.getHeal());
                    }
                    level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12321_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                break;
            }
            case 6: {
                LivingEntity living = SkillHelper.getTargetingEntity(entity, 5.0, false);
                if (living == null || !living.m_6084_()) {
                    return;
                }
                if (!SkillHelper.isSubordinate(entity, living)) {
                    return;
                }
                if (living.m_6095_().m_204039_(TensuraTags.EntityTypes.NO_SKILL_PLUNDER)) {
                    return;
                }
                List<ManasSkillInstance> collection = SkillAPI.getSkillsFrom((Entity)living).getLearnedSkills().stream().filter(sub -> StarvedSkill.canGain(sub.getSkill())).toList();
                for (ManasSkillInstance targetInstance : collection) {
                    SkillPlunderEvent event;
                    if (targetInstance.isTemporarySkill() || targetInstance.getMastery() < 0 || targetInstance.getSkill() == this || MinecraftForge.EVENT_BUS.post((Event)(event = new SkillPlunderEvent((Entity)living, (Entity)entity, false, targetInstance.getSkill()))) || !SkillUtils.learnSkill(entity, event.getSkill(), instance.getRemoveTime())) continue;
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire", (Object[])new Object[]{event.getSkill().getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                    }
                    level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_175828_, entity.m_20185_(), entity.m_20186_() + (double)entity.m_20206_() / 2.0, entity.m_20189_(), 20, 0.08, 0.08, 0.08, 0.15);
                }
                break;
            }
            case 7: {
                SkillHelper.comingSoonMessage(entity, "Provide");
            }
        }
    }

    private boolean corrosion(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        List list;
        if (heldTicks % 20 == 0 && SkillHelper.outOfMagicule(entity, instance)) {
            return false;
        }
        if (heldTicks % 100 == 0 && heldTicks > 0) {
            this.addMasteryPoint(instance, entity);
        }
        Level level = entity.m_9236_();
        level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12031_, SoundSource.PLAYERS, 1.0f, 1.0f);
        if (heldTicks % 10 == 0) {
            TensuraNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new RequestFxSpawningPacket(new ResourceLocation("tensura:gluttony_corrosion"), entity.m_19879_(), 0.0, 1.0, 0.0, true));
        }
        if (heldTicks % 10 == 0 && !(list = level.m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(5.0), living -> !living.m_7306_((Entity)entity) && living.m_6084_() && !living.m_7307_((Entity)entity))).isEmpty()) {
            for (LivingEntity target : list) {
                if (!target.m_6469_((DamageSource)this.sourceWithMP(TensuraDamageSources.corrosion((Entity)entity), entity, instance), 10.0f) || !target.m_21224_()) continue;
                if (!target.m_6095_().m_204039_(TensuraTags.EntityTypes.NO_SKILL_PLUNDER)) {
                    List<ManasSkillInstance> targetSkills = SkillAPI.getSkillsFrom((Entity)target).getLearnedSkills().stream().filter(skillInstance -> StarvedSkill.canGain(skillInstance.getSkill())).toList();
                    for (ManasSkillInstance targetInstance : targetSkills) {
                        SkillPlunderEvent event;
                        if (targetInstance.isTemporarySkill() || targetInstance.getMastery() < 0 || targetInstance.getSkill() == this || MinecraftForge.EVENT_BUS.post((Event)(event = new SkillPlunderEvent((Entity)target, (Entity)entity, false, targetInstance.getSkill()))) || !SkillUtils.learnSkill(entity, event.getSkill(), instance.getRemoveTime()) || !(entity instanceof Player)) continue;
                        Player player = (Player)entity;
                        player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire", (Object[])new Object[]{event.getSkill().getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                    }
                }
                if (instance.isTemporarySkill()) continue;
                CompoundTag tag = instance.getOrCreateTag();
                if (tag.m_128441_("predationList")) {
                    String targetID;
                    predationList = (CompoundTag)tag.m_128423_("predationList");
                    if (predationList == null || predationList.m_128441_(targetID = EntityType.m_20613_((EntityType)target.m_6095_()).toString())) continue;
                    predationList.m_128379_(targetID, true);
                } else {
                    predationList = new CompoundTag();
                    predationList.m_128379_(EntityType.m_20613_((EntityType)target.m_6095_()).toString(), true);
                    tag.m_128365_("predationList", (Tag)predationList);
                }
                if (target.m_6095_().m_204039_(TensuraTags.EntityTypes.NO_EP_PLUNDER)) continue;
                double EP = Math.min(SkillUtils.getEPGain(target, entity), (Double)TensuraConfig.INSTANCE.skillsConfig.maximumEPSteal.get());
                if (target instanceof Player) {
                    Player playerTarget = (Player)target;
                    if (TensuraGameRules.canEpSteal(target.m_9236_())) {
                        int minEP = TensuraGameRules.getMinEp(level);
                        if (minEP > 0) {
                            EP -= (double)minEP;
                        }
                        if (EP <= 0.0) continue;
                        SkillHelper.gainMaxMP(entity, EP * 0.4);
                        SkillHelper.gainMaxAP(entity, EP * 0.4);
                        TensuraEPCapability.setSkippingEPDrop(target, true);
                        SkillHelper.gainMP(entity, EP * 0.4, false);
                        SkillHelper.gainAP(entity, EP * 0.4, false);
                        TensuraPlayerCapability.getFrom(playerTarget).ifPresent(cap -> {
                            cap.setBaseMagicule((double)minEP / 2.0, (LivingEntity)playerTarget);
                            cap.setBaseAura((double)minEP / 2.0, (LivingEntity)playerTarget);
                        });
                        TensuraPlayerCapability.sync(playerTarget);
                    }
                } else {
                    SkillHelper.gainMaxMP(entity, EP * 0.4);
                    SkillHelper.gainMaxAP(entity, EP * 0.4);
                    TensuraEPCapability.setSkippingEPDrop(target, true);
                    SkillHelper.gainMP(entity, EP * 0.4, false);
                    SkillHelper.gainAP(entity, EP * 0.4, false);
                    SkillHelper.reduceEP(target, entity, 1.0, true, true);
                }
                tag.m_128347_("storedMP", tag.m_128459_("storedMP") + EP * 0.1);
                tag.m_128347_("storedAP", tag.m_128459_("storedAP") + EP * 0.1);
                instance.markDirty();
            }
        }
        return true;
    }

    @Override
    @NotNull
    public SpatialStorageContainer getSpatialStorage(ManasSkillInstance instance) {
        SpatialStorageContainer container = new SpatialStorageContainer(81, 666);
        container.m_7797_(instance.getOrCreateTag().m_128437_("SpatialStorage", 10));
        return container;
    }
}

