/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2client.RequestFxSpawningPacket;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.world.TensuraGameRules;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class EnvySkill
extends Skill {
    public EnvySkill() {
        super(Skill.SkillType.UNIQUE);
    }

    @Override
    public double getObtainingEpCost() {
        return 100000.0;
    }

    @Override
    public int getMaxMastery() {
        return 1500;
    }

    @Override
    public int modes() {
        return 2;
    }

    @Override
    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        return instance.getMode() == 1 ? 2 : 1;
    }

    @Override
    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"tensura.skill.mode.envy.absorb");
            case 2 -> Component.m_237115_((String)"tensura.skill.mode.envy.strength_sap");
            default -> Component.m_237119_();
        };
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        if (instance.getMode() == 2) {
            return 1000.0;
        }
        return 0.0;
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        return this.isInSlot(entity);
    }

    public void onTick(ManasSkillInstance instance, LivingEntity entity) {
        if (!this.isInSlot(entity)) {
            return;
        }
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19621_, 240, 2, false, false, false));
        entity.m_21195_(MobEffects.f_19613_);
        entity.m_21195_(MobEffects.f_19597_);
    }

    @Override
    @NotNull
    public List<MobEffect> getImmuneEffects(ManasSkillInstance instance, LivingEntity entity) {
        if (!this.isInSlot(entity)) {
            return new ArrayList<MobEffect>();
        }
        return List.of(MobEffects.f_19613_, MobEffects.f_19597_);
    }

    public void onBeingDamaged(ManasSkillInstance instance, LivingAttackEvent event) {
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (!this.isInSlot(entity)) {
            return;
        }
        DamageSource damageSource = event.getSource();
        if (damageSource.m_19378_() || damageSource.m_19387_()) {
            return;
        }
        if (damageSource.m_7640_() == null || damageSource.m_7640_() != damageSource.m_7639_()) {
            return;
        }
        if (entity.m_217043_().m_188501_() > 0.2f) {
            return;
        }
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 2.0f, 1.0f);
        event.setCanceled(true);
        if (SkillUtils.canNegateDodge(entity, damageSource)) {
            event.setCanceled(false);
        }
    }

    public void onProjectileHit(ManasSkillInstance instance, LivingEntity entity, ProjectileImpactEvent event) {
        if (!this.isInSlot(entity)) {
            return;
        }
        if (SkillUtils.isProjectileAlwaysHit(event.getProjectile())) {
            return;
        }
        if (entity.m_217043_().m_188501_() > 0.2f) {
            return;
        }
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 2.0f, 1.0f);
        event.setCanceled(true);
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        List list;
        if (instance.getMode() != 2) {
            return false;
        }
        if (heldTicks % 20 == 0 && SkillHelper.outOfMagicule(entity, instance)) {
            return false;
        }
        if (heldTicks % 200 == 0) {
            if (heldTicks > 0) {
                this.addMasteryPoint(instance, entity);
            }
            if ((double)entity.m_217043_().m_188501_() <= 0.2) {
                int level = 0;
                MobEffectInstance insanity = entity.m_21124_((MobEffect)TensuraMobEffects.INSANITY.get());
                if (insanity != null) {
                    level = insanity.m_19564_() + 1;
                }
                entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.INSANITY.get(), 240, level, false, false, false));
            }
        }
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12362_, SoundSource.PLAYERS, 0.5f, 0.5f);
        if (heldTicks % 10 == 0) {
            TensuraNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new RequestFxSpawningPacket(new ResourceLocation("tensura:strength_sap"), entity.m_19879_(), 0.0, 1.0, 0.0, true));
        }
        if (!(list = entity.m_9236_().m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(15.0), living -> !living.m_7306_((Entity)entity) && living.m_6084_() && !living.m_7307_((Entity)entity))).isEmpty()) {
            double ownerEP = TensuraEPCapability.getEP(entity);
            for (LivingEntity target : list) {
                if (target instanceof Player) {
                    Player player = (Player)target;
                    if (player.m_150110_().f_35934_) continue;
                }
                double targetEP = TensuraEPCapability.getEP(target);
                double difference = 1.0 - targetEP / ownerEP - 0.4;
                if (instance.isMastered(entity)) {
                    difference += 0.2;
                }
                if (difference < 0.0) continue;
                int level = 1 + (int)(difference / 0.1);
                target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 200, level));
                target.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 200, level));
                SkillHelper.reduceEnergy(target, entity, 0.001, true);
            }
        }
        return true;
    }

    private boolean failedAbsorb(LivingEntity entity, double EP, double targetEP) {
        if (targetEP > EP * 10.0) {
            return (double)entity.m_217043_().m_188501_() >= 0.1;
        }
        if (targetEP >= EP * 5.0) {
            return (double)entity.m_217043_().m_188501_() >= 0.2;
        }
        return (double)entity.m_217043_().m_188501_() >= 0.3;
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        if (instance.getMode() == 2) {
            return;
        }
        if (SkillHelper.outOfMagicule(entity, instance)) {
            return;
        }
        Level level = entity.m_9236_();
        LivingEntity target = SkillHelper.getTargetingEntity(entity, 5.0, false);
        if (target != null && target.m_6084_()) {
            if (target instanceof Player) {
                Player player = (Player)target;
                if (player.m_150110_().f_35934_) {
                    return;
                }
            }
            double EP = TensuraEPCapability.getEP(entity);
            double targetEP = SkillUtils.getEPGain(target, entity);
            if (targetEP < EP) {
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.m_5661_((Component)Component.m_237115_((String)"tensura.targeting.ep_not_meet").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                }
                return;
            }
            this.addMasteryPoint(instance, entity);
            if (this.failedAbsorb(entity, EP, targetEP)) {
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.m_5661_((Component)Component.m_237115_((String)"tensura.ability.activation_failed").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                }
                level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 1.0f, 1.0f);
                return;
            }
            double difference = Math.min((double)target.m_217043_().m_188501_() >= 0.4 ? (targetEP - EP) / 2.0 : targetEP - EP, (Double)TensuraConfig.INSTANCE.skillsConfig.maximumEPSteal.get());
            if (target instanceof Player) {
                Player playerTarget = (Player)target;
                if (TensuraGameRules.canEpSteal(level)) {
                    DamageSourceHelper.markHurt(target, (Entity)entity);
                    SkillHelper.gainMaxMP(entity, difference / 2.0);
                    SkillHelper.gainMP(entity, difference / 4.0, false);
                    SkillHelper.gainAP(entity, difference / 4.0, false);
                    TensuraPlayerCapability.getFrom(playerTarget).ifPresent(cap -> {
                        double reducedAura = cap.getBaseAura() - difference / 2.0;
                        double reducedMana = cap.getBaseMagicule() - difference / 2.0;
                        if (reducedAura < 0.0) {
                            reducedMana -= reducedAura * -1.0;
                            reducedAura = 100.0;
                        } else if (reducedMana < 0.0) {
                            reducedAura -= reducedMana * -1.0;
                            reducedMana = 100.0;
                        }
                        double minusMP = cap.getBaseMagicule() - reducedMana;
                        cap.setMagicule(cap.getMagicule() - minusMP);
                        double minusAP = cap.getBaseAura() - reducedAura;
                        cap.setAura(cap.getAura() - minusAP);
                        cap.setBaseMagicule(reducedMana, (LivingEntity)playerTarget);
                        cap.setBaseAura(reducedAura, (LivingEntity)playerTarget);
                    });
                    TensuraPlayerCapability.sync(playerTarget);
                    instance.setCoolDown(instance.isMastered(entity) ? 10 : 30);
                    entity.m_21011_(InteractionHand.MAIN_HAND, true);
                    level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12049_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123792_, 1.0);
                } else if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.m_5661_((Component)Component.m_237115_((String)"tensura.targeting.not_allowed").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                }
            } else {
                if (target.m_6095_().m_204039_(TensuraTags.EntityTypes.NO_EP_PLUNDER)) {
                    return;
                }
                DamageSourceHelper.markHurt(target, (Entity)entity);
                SkillHelper.gainMaxMP(entity, difference / 2.0);
                SkillHelper.gainMP(entity, difference / 4.0, false);
                SkillHelper.gainAP(entity, difference / 4.0, false);
                TensuraEPCapability.getFrom(target).ifPresent(cap -> cap.setEP(target, cap.getEP() - difference));
                instance.setCoolDown(instance.isMastered(entity) ? 10 : 30);
                entity.m_21011_(InteractionHand.MAIN_HAND, true);
                level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12049_, SoundSource.PLAYERS, 1.0f, 1.0f);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123792_, 1.0);
            }
        } else if (entity instanceof Player) {
            Player player = (Player)entity;
            player.m_5661_((Component)Component.m_237115_((String)"tensura.targeting.not_targeted").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
        }
    }
}

