/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.capability.skill.TensuraSkillCapability;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.menu.SkillCreatorMenu;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkHooks;

public class CreatorSkill
extends Skill {
    public CreatorSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    @Override
    public double getObtainingEpCost() {
        return 75000.0;
    }

    @Override
    public double learningCost() {
        return 1000.0;
    }

    @Override
    protected boolean canActivateInRaceLimit(ManasSkillInstance instance) {
        return instance.getMode() == 1;
    }

    public boolean canIgnoreCoolDown(ManasSkillInstance instance, LivingEntity entity) {
        return instance.getMode() == 1;
    }

    @Override
    public int modes() {
        return 2;
    }

    @Override
    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        return instance.getMode() == 1 ? 2 : 1;
    }

    @Override
    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"tensura.skill.mode.creator.analytical_appraisal");
            case 2 -> Component.m_237115_((String)"tensura.skill.mode.creator.skill_creation");
            default -> Component.m_237119_();
        };
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        switch (instance.getMode()) {
            case 1: {
                if (!(entity instanceof Player)) {
                    return;
                }
                Player player = (Player)entity;
                TensuraSkillCapability.getFrom(player).ifPresent(cap -> {
                    int level;
                    if (player.m_6047_()) {
                        int mode = cap.getAnalysisMode();
                        switch (mode) {
                            case 1: {
                                cap.setAnalysisMode(2);
                                player.m_5661_((Component)Component.m_237115_((String)"tensura.skill.analytical.analyzing_mode.block").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA)), true);
                                break;
                            }
                            case 2: {
                                cap.setAnalysisMode(0);
                                player.m_5661_((Component)Component.m_237115_((String)"tensura.skill.analytical.analyzing_mode.both").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA)), true);
                                break;
                            }
                            default: {
                                cap.setAnalysisMode(1);
                                player.m_5661_((Component)Component.m_237115_((String)"tensura.skill.analytical.analyzing_mode.entity").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA)), true);
                            }
                        }
                        player.m_6330_(SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        TensuraSkillCapability.sync(player);
                        return;
                    }
                    int n = level = instance.isMastered(entity) ? 6 : 2;
                    if (cap.getAnalysisLevel() != level) {
                        cap.setAnalysisLevel(level);
                        cap.setAnalysisDistance(instance.isMastered(entity) ? 10 : 5);
                        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    } else {
                        cap.setAnalysisLevel(0);
                        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                    TensuraSkillCapability.sync(player);
                });
                break;
            }
            case 2: {
                if (!(entity instanceof ServerPlayer)) break;
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                List<ResourceLocation> list = ((List)TensuraConfig.INSTANCE.skillsConfig.skillCreatorSkills.get()).stream().map(ResourceLocation::new).filter(location -> this.canCreateSkill((ResourceLocation)location, serverPlayer, instance)).toList();
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new SimpleMenuProvider(SkillCreatorMenu::new, (Component)Component.m_237119_()), buf -> buf.m_236828_((Collection)list, FriendlyByteBuf::m_130085_));
                serverPlayer.m_6330_(SoundEvents.f_11889_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    private boolean canCreateSkill(ResourceLocation location, ServerPlayer serverPlayer, ManasSkillInstance instance) {
        ResourceLocation created;
        ManasSkill skill = (ManasSkill)SkillAPI.getSkillRegistry().getValue(location);
        if (skill == null) {
            return false;
        }
        Optional optional = SkillAPI.getSkillsFrom((Entity)serverPlayer).getSkill(skill);
        if (instance.isMastered((LivingEntity)serverPlayer)) {
            return optional.map(ManasSkillInstance::isTemporarySkill).orElse(true);
        }
        CompoundTag tag = instance.getTag();
        if (tag != null && tag.m_128441_("created_skill") && (created = new ResourceLocation(tag.m_128461_("created_skill"))).equals((Object)location)) {
            return false;
        }
        return optional.isEmpty();
    }
}

