/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.capability.effects.TensuraEffectsCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class ChefSkill
extends Skill {
    public ChefSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    @Override
    public double learningCost() {
        return 1000.0;
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 100.0;
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        boolean success;
        LivingEntity living = SkillHelper.getTargetingEntity(entity, 3.0, false);
        if (living != null && entity.m_6144_()) {
            success = TensuraEffectsCapability.getSeverance(living) > 0.0;
            TensuraEffectsCapability.getFrom(living).ifPresent(cap -> cap.setSeveranceAmount(0.0));
            Predicate<MobEffect> predicate = effect -> effect.m_19483_() == MobEffectCategory.HARMFUL;
            success = success || SkillHelper.removePredicateEffect(living, predicate, this.magiculeCost(entity, instance));
            int cost = instance.isMastered(entity) ? 40 : 60;
            float lackedHealth = living.m_21233_() - living.m_21223_();
            double lackedMagicule = SkillHelper.outOfMagiculeStillConsume(entity, (int)(lackedHealth * (float)cost));
            if (lackedMagicule > 0.0) {
                lackedHealth = (float)((double)lackedHealth - lackedMagicule / (double)cost);
            }
            living.m_5634_(lackedHealth);
            boolean bl = success = success || lackedHealth > 0.0f;
            if (success) {
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)living, (ParticleOptions)ParticleTypes.f_123749_, 2.0);
            }
        } else {
            success = TensuraEffectsCapability.getSeverance(entity) > 0.0;
            TensuraEffectsCapability.getFrom(entity).ifPresent(cap -> cap.setSeveranceAmount(0.0));
            Predicate<MobEffect> predicate = effect -> effect.m_19483_() == MobEffectCategory.HARMFUL;
            success = success || SkillHelper.removePredicateEffect(entity, predicate, this.magiculeCost(entity, instance));
            int cost = instance.isMastered(entity) ? 40 : 60;
            float lackedHealth = entity.m_21233_() - entity.m_21223_();
            double lackedMagicule = SkillHelper.outOfMagiculeStillConsume(entity, (int)(lackedHealth * (float)cost));
            if (lackedMagicule > 0.0) {
                lackedHealth = (float)((double)lackedHealth - lackedMagicule / (double)cost);
            }
            entity.m_5634_(lackedHealth);
            boolean bl = success = success || lackedHealth > 0.0f;
            if (success) {
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_123749_, 2.0);
            }
        }
        if (success) {
            this.addMasteryPoint(instance, entity);
            instance.setCoolDown(instance.isMastered(entity) ? 3 : 5);
            entity.m_21011_(InteractionHand.MAIN_HAND, true);
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11937_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }
}

