/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.intrinsic.CharmSkill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.entity.template.TensuraHorseEntity;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import com.github.manasmods.tensura.race.RaceHelper;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.skill.ResistanceSkills;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class BewilderSkill
extends Skill {
    public BewilderSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    @Override
    public double getObtainingEpCost() {
        return 30000.0;
    }

    @Override
    public int modes() {
        return 4;
    }

    @Override
    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return instance.getMode() == 1 ? 4 : instance.getMode() - 1;
        }
        return instance.getMode() == 4 ? 1 : instance.getMode() + 1;
    }

    @Override
    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"tensura.skill.mode.bewilder.target");
            case 2 -> Component.m_237115_((String)"tensura.skill.mode.bewilder.area");
            case 3 -> Component.m_237115_((String)"tensura.skill.mode.bewilder.charm");
            case 4 -> Component.m_237115_((String)"tensura.skill.mode.bewilder.kill");
            default -> Component.m_237119_();
        };
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 4 -> 100.0;
            case 3 -> 200.0;
            case 2 -> 80.0;
            case 1 -> 50.0;
            default -> 0.0;
        };
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        Level level = entity.m_9236_();
        UUID uuid = entity.m_20148_();
        switch (instance.getMode()) {
            case 1: {
                LivingEntity target = SkillHelper.getTargetingEntity(entity, 5.0, false);
                if (target == null) {
                    return;
                }
                if (entity.m_6144_()) {
                    TensuraEPCapability.getFrom(target).ifPresent(cap -> {
                        if (Objects.equals(cap.getTemporaryOwner(), uuid)) {
                            cap.setTemporaryOwner(null);
                            target.m_21195_((MobEffect)TensuraMobEffects.MIND_CONTROL.get());
                            level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 1.0f, 1.0f);
                            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123798_);
                            TensuraEPCapability.sync(target);
                            entity.m_21011_(InteractionHand.MAIN_HAND, true);
                            UUID owner = cap.getPermanentOwner();
                            if (target instanceof TensuraTamableEntity) {
                                TensuraTamableEntity tamable = (TensuraTamableEntity)target;
                                tamable.resetOwner(owner);
                            } else if (target instanceof TensuraHorseEntity) {
                                TensuraHorseEntity horse = (TensuraHorseEntity)target;
                                horse.resetOwner(owner);
                            } else if (target instanceof TamableAnimal) {
                                TamableAnimal animal = (TamableAnimal)target;
                                animal.m_21816_(owner);
                                if (owner == null) {
                                    animal.m_7105_(false);
                                }
                            }
                        }
                    });
                    break;
                }
                if (target.m_21023_((MobEffect)TensuraMobEffects.RAMPAGE.get())) {
                    return;
                }
                if (CharmSkill.isMindControlFailed(entity, target, level)) {
                    return;
                }
                if (RaceHelper.isSpiritualLifeForm(target) && entity instanceof Player) {
                    Player player = (Player)entity;
                    player.m_5661_((Component)Component.m_237115_((String)"tensura.ability.activation_failed").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                    return;
                }
                TensuraEPCapability.getFrom(target).ifPresent(cap -> {
                    if (Objects.equals(cap.getPermanentOwner(), uuid)) {
                        return;
                    }
                    if (SkillHelper.outOfMagicule(entity, instance)) {
                        return;
                    }
                    if (Objects.equals(cap.getTemporaryOwner(), uuid)) {
                        return;
                    }
                    this.addMasteryPoint(instance, entity);
                    int duration = 12000;
                    if (SkillUtils.hasSkill((Entity)target, (ManasSkill)ResistanceSkills.SPIRITUAL_ATTACK_RESISTANCE.get())) {
                        duration /= 2;
                    }
                    SkillHelper.checkThenAddEffectSource(target, (Entity)entity, (MobEffect)TensuraMobEffects.MIND_CONTROL.get(), duration, 0);
                    if (!target.m_21023_((MobEffect)TensuraMobEffects.MIND_CONTROL.get())) {
                        return;
                    }
                    cap.setTemporaryOwner(uuid);
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        if (target instanceof TamableAnimal) {
                            TamableAnimal animal = (TamableAnimal)target;
                            animal.m_21828_(player);
                        } else if (target instanceof TensuraHorseEntity) {
                            TensuraHorseEntity horse = (TensuraHorseEntity)target;
                            horse.m_30637_(player);
                        }
                    }
                    TensuraEPCapability.sync(target);
                    entity.m_21011_(InteractionHand.MAIN_HAND, true);
                    level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11733_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123798_);
                });
                break;
            }
            case 2: {
                float radius = instance.isMastered(entity) ? 15.0f : 10.0f;
                List list = level.m_6443_(LivingEntity.class, entity.m_20191_().m_82400_((double)radius), livingEntity -> !livingEntity.m_7306_((Entity)entity) && livingEntity.m_6084_());
                if (list.isEmpty()) {
                    return;
                }
                if (SkillHelper.outOfMagicule(entity, this.magiculeCost(entity, instance) * (double)list.size())) {
                    return;
                }
                this.addMasteryPoint(instance, entity);
                level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11733_, SoundSource.PLAYERS, 1.0f, 1.0f);
                for (LivingEntity target : list) {
                    if (!CharmSkill.canMindControl(target, level) || target.m_21023_((MobEffect)TensuraMobEffects.RAMPAGE.get()) || RaceHelper.isSpiritualLifeForm(target) || SkillUtils.isSkillToggled((Entity)target, (ManasSkill)ResistanceSkills.SPIRITUAL_ATTACK_NULLIFICATION.get())) continue;
                    int duration = SkillUtils.isSkillToggled((Entity)target, (ManasSkill)ResistanceSkills.SPIRITUAL_ATTACK_RESISTANCE.get()) ? 3000 : 6000;
                    SkillHelper.checkThenAddEffectSource(target, (Entity)entity, (MobEffect)TensuraMobEffects.MIND_CONTROL.get(), duration, 0);
                    if (!target.m_21023_((MobEffect)TensuraMobEffects.MIND_CONTROL.get())) continue;
                    TensuraEPCapability.getFrom(target).ifPresent(cap -> {
                        if (!Objects.equals(cap.getTemporaryOwner(), uuid)) {
                            cap.setTemporaryOwner(uuid);
                            if (entity instanceof Player) {
                                Player player = (Player)entity;
                                if (target instanceof TamableAnimal) {
                                    TamableAnimal animal = (TamableAnimal)target;
                                    animal.m_21828_(player);
                                } else if (target instanceof TensuraHorseEntity) {
                                    TensuraHorseEntity horse = (TensuraHorseEntity)target;
                                    horse.m_30637_(player);
                                }
                            }
                            TensuraEPCapability.sync(target);
                            entity.m_21011_(InteractionHand.MAIN_HAND, true);
                            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123798_);
                        }
                    });
                }
                break;
            }
            case 3: {
                if (SkillHelper.outOfMagicule(entity, instance)) {
                    return;
                }
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19595_, 2400, 4, false, false, true));
                level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12049_, SoundSource.PLAYERS, 1.0f, 1.0f);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_123798_);
                break;
            }
            case 4: {
                float radius = instance.isMastered(entity) ? 15.0f : 10.0f;
                List list = level.m_6443_(LivingEntity.class, entity.m_20191_().m_82400_((double)radius), livingEntity -> !livingEntity.m_7306_((Entity)entity) && livingEntity.m_6084_() && livingEntity.m_21023_((MobEffect)TensuraMobEffects.MIND_CONTROL.get()));
                if (list.isEmpty()) {
                    return;
                }
                if (SkillHelper.outOfMagicule(entity, this.magiculeCost(entity, instance) * (double)list.size())) {
                    return;
                }
                instance.setCoolDown(instance.isMastered(entity) ? 3 : 5);
                entity.m_21011_(InteractionHand.MAIN_HAND, true);
                this.addMasteryPoint(instance, entity);
                for (LivingEntity target : list) {
                    if (!Objects.equals(uuid, TensuraEPCapability.getTemporaryOwner(target))) continue;
                    float damage = target.m_21223_();
                    if (SkillUtils.hasSkill((Entity)target, (ManasSkill)ResistanceSkills.SPIRITUAL_ATTACK_RESISTANCE.get())) {
                        damage /= 2.0f;
                    }
                    if (!target.m_6469_((DamageSource)this.sourceWithMP(TensuraDamageSources.selfKill((Entity)entity), entity, instance), damage)) continue;
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123808_);
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123792_);
                }
                break;
            }
        }
    }
}

