/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.entity.magic.TensuraProjectile;
import com.github.manasmods.tensura.entity.magic.projectile.SeveranceCutterProjectile;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class AbsoluteSeveranceSkill
extends Skill {
    public AbsoluteSeveranceSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    @Override
    public double getObtainingEpCost() {
        return 15000.0;
    }

    @Override
    public double learningCost() {
        return 1000.0;
    }

    @Override
    public int modes() {
        return 2;
    }

    @Override
    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        return instance.getMode() == 1 ? 2 : 1;
    }

    @Override
    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"tensura.skill.mode.absolute_severance.coat");
            case 2 -> Component.m_237115_((String)"tensura.skill.mode.absolute_severance.projectile");
            default -> Component.m_237119_();
        };
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 2 -> 500.0;
            case 1 -> 1000.0;
            default -> 0.0;
        };
    }

    public void onToggleOff(ManasSkillInstance instance, LivingEntity entity) {
        if (entity.m_21023_((MobEffect)TensuraMobEffects.SEVERANCE_BLADE.get())) {
            entity.m_21195_((MobEffect)TensuraMobEffects.SEVERANCE_BLADE.get());
        }
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        if (SkillHelper.outOfMagicule(entity, instance)) {
            return;
        }
        switch (instance.getMode()) {
            case 1: {
                if (entity.m_21023_((MobEffect)TensuraMobEffects.SEVERANCE_BLADE.get())) {
                    entity.m_21195_((MobEffect)TensuraMobEffects.SEVERANCE_BLADE.get());
                    entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    break;
                }
                int severance = instance.isMastered(entity) ? 19 : 4;
                entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.SEVERANCE_BLADE.get(), 1200, severance, false, false, false));
                entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
            case 2: {
                SeveranceCutterProjectile spaceCutter = new SeveranceCutterProjectile(entity.m_9236_(), entity);
                spaceCutter.setSpeed(2.5f);
                spaceCutter.setDamage(this.isMastered(instance, entity) ? 300.0f : 50.0f);
                spaceCutter.setSize(this.isMastered(instance, entity) ? 8.0f : 5.0f);
                spaceCutter.setMpCost(this.magiculeCost(entity, instance));
                spaceCutter.setSkill(instance);
                spaceCutter.m_20242_(true);
                spaceCutter.setPosAndShoot(entity);
                spaceCutter.setPosDirection(entity, TensuraProjectile.PositionDirection.MIDDLE);
                entity.m_9236_().m_7967_((Entity)spaceCutter);
                instance.addMasteryPoint(entity);
                instance.setCoolDown(3);
                entity.m_21011_(InteractionHand.MAIN_HAND, true);
                entity.m_21011_(InteractionHand.OFF_HAND, true);
                entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12520_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }
}

