/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.resist;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.skill.resist.ResistSkill;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.skill.ResistanceSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public class AbnormalConditionResistance
extends ResistSkill {
    public static final ImmutableList<MobEffect> ABNORMAL_RESIST = ImmutableList.of((Object)MobEffects.f_19612_, (Object)MobEffects.f_19614_, (Object)MobEffects.f_19610_, (Object)MobEffects.f_19604_, (Object)MobEffects.f_216964_, (Object)MobEffects.f_19599_, (Object)MobEffects.f_19597_, (Object)MobEffects.f_19613_, (Object)((MobEffect)TensuraMobEffects.BURDEN.get()), (Object)((MobEffect)TensuraMobEffects.FRAGILITY.get()), (Object)((MobEffect)TensuraMobEffects.CURSE.get()));

    @Override
    public boolean isDamageResisted(DamageSource damageSource, ManasSkillInstance instance) {
        return DamageSourceHelper.isAbnormal(damageSource);
    }

    @Override
    public double learningCost() {
        return 15.0;
    }

    @Override
    public int pointRequirement() {
        return 700;
    }

    @Override
    @NotNull
    public List<MobEffect> getImmuneEffects(ManasSkillInstance instance, LivingEntity entity) {
        if (!instance.isToggled()) {
            return new ArrayList<MobEffect>();
        }
        return ABNORMAL_RESIST;
    }

    @Override
    @Nullable
    protected ManasSkill getNullificationForm() {
        return (ManasSkill)ResistanceSkills.ABNORMAL_CONDITION_NULLIFICATION.get();
    }
}

