/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.intrinsic;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.race.RaceHelper;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class UltrasonicWavesSkill
extends Skill {
    public UltrasonicWavesSkill() {
        super(Skill.SkillType.INTRINSIC);
    }

    @Override
    public int modes() {
        return 2;
    }

    @Override
    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        return instance.getMode() == 1 ? 2 : 1;
    }

    @Override
    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"tensura.skill.mode.ultrasonic_waves.sonic_boom");
            case 2 -> Component.m_237115_((String)"tensura.skill.mode.ultrasonic_waves.auditory_sense");
            default -> Component.m_237119_();
        };
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 30.0;
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        Level level = entity.m_9236_();
        if (instance.getMode() == 2) {
            if (entity.m_21023_((MobEffect)TensuraMobEffects.AUDITORY_SENSE.get())) {
                return;
            }
            entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.AUDITORY_SENSE.get(), 200, 0, false, false, false));
            return;
        }
        if (SkillHelper.outOfMagicule(entity, instance)) {
            return;
        }
        this.addMasteryPoint(instance, entity);
        instance.setCoolDown(instance.isMastered(entity) ? 1 : 3);
        Vec3 target = entity.m_20182_().m_82549_(entity.m_20154_().m_82490_(8.0));
        Vec3 source = entity.m_20182_().m_82520_(0.0, (double)entity.m_20192_(), 0.0);
        Vec3 sourceToTarget = target.m_82546_(source);
        Vec3 normalizes = sourceToTarget.m_82541_();
        level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_215771_, SoundSource.PLAYERS, 5.0f, 1.0f);
        for (int particleIndex = 1; particleIndex < Mth.m_14107_((double)sourceToTarget.m_82553_()); ++particleIndex) {
            Vec3 particlePos = source.m_82549_(normalizes.m_82490_((double)particleIndex));
            ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_235902_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
            AABB aabb = new AABB(new BlockPos(particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_)).m_82400_(2.0);
            List list = level.m_6443_(LivingEntity.class, aabb, entityData -> !entityData.m_7306_((Entity)entity) && !entityData.m_7307_((Entity)entity));
            if (list.isEmpty()) continue;
            for (LivingEntity living : list) {
                if (RaceHelper.isSpiritualLifeForm(living)) continue;
                DamageSource damagesource = new EntityDamageSource("sonic_boom", (Entity)entity).m_19389_();
                living.m_6469_((DamageSource)this.sourceWithMP(damagesource, entity, instance), 8.0f);
            }
        }
    }
}

