/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.intrinsic;

import com.github.manasmods.manascore.api.attribute.AttributeModifierHelper;
import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.manascore.attribute.ManasCoreAttributes;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.entity.human.CloneEntity;
import com.github.manasmods.tensura.event.PossessionEvent;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.race.RaceHelper;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.dimensions.TensuraDimensions;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.skill.ResistanceSkills;
import com.github.manasmods.tensura.util.attribute.TensuraAttributeModifierIds;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.lang3.tuple.Triple;

public class PossessionSkill
extends Skill {
    public PossessionSkill() {
        super(Skill.SkillType.INTRINSIC);
    }

    private boolean canPossess(LivingEntity target, Player player) {
        Player targetPlayer;
        if (target.m_6095_().m_204039_(TensuraTags.EntityTypes.NO_POSSESSION)) {
            return false;
        }
        if (RaceHelper.isSpiritualLifeForm(target)) {
            return false;
        }
        if (player.m_7500_()) {
            return true;
        }
        if (target instanceof CloneEntity) {
            CloneEntity clone = (CloneEntity)target;
            if (clone.getSkill() != this) {
                return false;
            }
            if (clone.m_21826_() == player) {
                return true;
            }
        }
        if (SkillUtils.isSkillToggled((Entity)target, (ManasSkill)ResistanceSkills.SPIRITUAL_ATTACK_NULLIFICATION.get())) {
            return false;
        }
        double amplifier = 1.0;
        if (SkillUtils.isSkillToggled((Entity)target, (ManasSkill)ResistanceSkills.SPIRITUAL_ATTACK_RESISTANCE.get())) {
            amplifier = 0.5;
        }
        if (target instanceof Player && !(targetPlayer = (Player)target).m_7500_() && !target.m_5833_()) {
            int requirement = 0;
            if ((double)target.m_21223_() < (double)(target.m_21233_() * 0.1f) * amplifier) {
                ++requirement;
            }
            if (TensuraEPCapability.getSpiritualHealth(target) < target.m_21133_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get()) * (double)0.1f * amplifier) {
                ++requirement;
            }
            if (TensuraEPCapability.getEP(target) < TensuraEPCapability.getEP((LivingEntity)player) * 0.25 * amplifier) {
                ++requirement;
            }
            return requirement >= 2;
        }
        if ((double)target.m_21223_() < (double)target.m_21233_() * 0.1 * amplifier) {
            return true;
        }
        if (TensuraEPCapability.getSpiritualHealth(target) < target.m_21133_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get()) * (double)0.1f * amplifier) {
            return true;
        }
        return TensuraEPCapability.getEP(target) < TensuraEPCapability.getEP((LivingEntity)player) * 0.25 * amplifier;
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity owner) {
        if (!(owner instanceof Player)) {
            return;
        }
        Player player = (Player)owner;
        Level level = owner.m_9236_();
        if (level.m_46472_().equals(TensuraDimensions.HELL) || level.m_46472_().equals(TensuraDimensions.LABYRINTH)) {
            player.m_5661_((Component)Component.m_237115_((String)"tensura.ability.activation_failed").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            return;
        }
        TensuraPlayerCapability.getFrom(player).ifPresent(cap -> {
            if (cap.isSpiritualForm()) {
                CloneEntity clone;
                LivingEntity target = SkillHelper.getTargetingEntity(owner, 5.0, false);
                if (target == null || !target.m_6084_()) {
                    return;
                }
                if (!this.canPossess(target, player)) {
                    player.m_5661_((Component)Component.m_237115_((String)"tensura.targeting.not_allowed").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                    return;
                }
                PossessionEvent event = new PossessionEvent(target, (Entity)player);
                if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                    return;
                }
                ((ServerPlayer)player).m_8999_((ServerLevel)level, target.m_20182_().f_82479_, target.m_20182_().f_82480_, target.m_20182_().f_82481_, target.m_146908_(), target.m_146909_());
                player.f_19864_ = true;
                level.m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_11862_, SoundSource.PLAYERS, 1.0f, 1.0f);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123765_, 2.0, 20);
                this.copyStatsAndSkills(target, player);
                CloneEntity.copyEffects(target, (LivingEntity)player);
                if (target instanceof CloneEntity && (clone = (CloneEntity)target).m_21830_((LivingEntity)player)) {
                    clone.copyEquipmentsOntoOwner((LivingEntity)player, false);
                    clone.resetOwner(null);
                }
                if (target instanceof Player) {
                    Player targetPlayer = (Player)target;
                    TensuraPlayerCapability.getFrom(targetPlayer).ifPresent(targetCap -> {
                        targetCap.setSpiritualForm(true);
                        targetCap.applyBaseAttributeModifiers((LivingEntity)targetPlayer);
                        targetPlayer.m_150110_().f_35936_ = true;
                        targetPlayer.m_150110_().f_35935_ = true;
                        targetPlayer.m_6885_();
                        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)targetPlayer);
                        for (ManasSkillInstance temp : List.copyOf(storage.getLearnedSkills())) {
                            if (!temp.isTemporarySkill()) continue;
                            if (temp.getTag() != null) {
                                temp.getTag().m_128473_("SpatialStorage");
                            }
                            storage.forgetSkill(temp);
                        }
                    });
                    TensuraPlayerCapability.sync(targetPlayer);
                } else {
                    target.m_217045_();
                    if (!target.m_6469_(TensuraDamageSources.SOUL_SCATTER, target.m_21233_() * 10.0f)) {
                        target.m_6667_(TensuraDamageSources.SOUL_SCATTER);
                        target.m_146870_();
                    } else {
                        target.f_20919_ = 19;
                    }
                }
                cap.setSpiritualForm(false);
                if (!player.m_7500_() && !player.m_5833_()) {
                    player.m_150110_().f_35936_ = false;
                    player.m_150110_().f_35935_ = false;
                    player.m_6885_();
                }
            } else {
                AttributeModifier cloneModifier;
                double EP = TensuraEPCapability.getEP(owner);
                EntityType type = (EntityType)TensuraEntityTypes.CLONE_DEFAULT.get();
                CloneEntity clone = new CloneEntity((EntityType<? extends CloneEntity>)type, level);
                clone.setLife((Integer)TensuraConfig.INSTANCE.skillsConfig.bodyDespawnTick.get() * 20);
                clone.m_21828_(player);
                clone.setSkill(this);
                clone.setImmobile(true);
                clone.m_21153_(owner.m_21223_());
                clone.copyEquipments(owner);
                for (EquipmentSlot slot : EquipmentSlot.values()) {
                    player.m_8061_(slot, ItemStack.f_41583_);
                }
                TensuraEPCapability.setLivingEP((LivingEntity)clone, Math.max(EP / 100.0, 100.0));
                clone.copyStatsAndSkills(owner, CloneEntity.CopySkill.INTRINSIC, true);
                clone.m_7311_(owner.m_20094_());
                CloneEntity.copyEffects((LivingEntity)player, (LivingEntity)clone);
                AttributeInstance cloneHP = clone.m_21051_(Attributes.f_22276_);
                Race race = TensuraPlayerCapability.getRace((LivingEntity)player);
                if (cloneHP != null && race != null && (cloneModifier = cloneHP.m_22111_(TensuraAttributeModifierIds.RACE_BASE_HEALTH_MODIFIER_ID)) != null) {
                    double raceHP = race.getBaseHealth() - player.m_21172_(Attributes.f_22276_);
                    if (cloneModifier.m_22218_() == raceHP) {
                        clone.setLife(-1);
                        instance.getOrCreateTag().m_128362_("OriginalBody", clone.m_20148_());
                        instance.markDirty();
                    }
                }
                clone.m_7678_(owner.m_20182_().f_82479_, owner.m_20182_().f_82480_, owner.m_20182_().f_82481_, owner.m_146908_(), owner.m_146909_());
                level.m_7967_((Entity)clone);
                cap.setSpiritualForm(true);
                if (!player.m_7500_() && !player.m_5833_()) {
                    player.m_150110_().f_35936_ = true;
                    player.m_150110_().f_35935_ = true;
                    player.m_6885_();
                }
                cap.applyBaseAttributeModifiers((LivingEntity)player);
                level.m_6263_(null, owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
                SkillStorage storage = SkillAPI.getSkillsFrom((Entity)player);
                for (ManasSkillInstance temp : List.copyOf(storage.getLearnedSkills())) {
                    if (!temp.isTemporarySkill()) continue;
                    if (temp.getTag() != null) {
                        temp.getTag().m_128473_("SpatialStorage");
                    }
                    storage.forgetSkill(temp);
                }
            }
            TensuraPlayerCapability.sync(player);
        });
    }

    private boolean canCopySkill(ManasSkillInstance instance, LivingEntity target, boolean clone) {
        if (clone) {
            return instance.isTemporarySkill();
        }
        if (target instanceof Player) {
            Player player = (Player)target;
            if (instance.isTemporarySkill()) {
                return true;
            }
            return TensuraPlayerCapability.getIntrinsicList(player).contains(SkillUtils.getSkillId(instance.getSkill()));
        }
        return true;
    }

    public void copyStatsAndSkills(LivingEntity target, Player owner) {
        this.applyBaseAttributeModifiers((LivingEntity)owner, target);
        owner.m_21153_(Math.max(target.m_21223_(), 0.0f));
        for (MobEffectInstance instance : target.m_21220_()) {
            owner.m_7292_(new MobEffectInstance(instance));
        }
        boolean clone = target instanceof CloneEntity;
        for (ManasSkillInstance instance : List.copyOf(SkillAPI.getSkillsFrom((Entity)target).getLearnedSkills())) {
            if (!this.canCopySkill(instance, target, clone) || instance.getMastery() < 0 && instance.getMastery() != -100) continue;
            ManasSkillInstance copy = TensuraSkillInstance.fromNBT((CompoundTag)instance.toNBT());
            if (!copy.isTemporarySkill()) {
                copy.setRemoveTime(-2);
            }
            if (!SkillUtils.learnSkill((LivingEntity)owner, copy)) continue;
            owner.m_5661_((Component)Component.m_237110_((String)"tensura.skill.temporary.success_drain", (Object[])new Object[]{copy.getSkill().getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), false);
        }
    }

    public void applyBaseAttributeModifiers(LivingEntity owner, LivingEntity target) {
        double jump;
        for (Map.Entry<Attribute, Triple<UUID, String, Double>> map : this.getStatList().entrySet()) {
            double value;
            AttributeInstance attribute = target.m_21051_(map.getKey());
            if (attribute == null) {
                value = (Double)map.getValue().getRight();
            } else {
                value = target.m_21172_(map.getKey());
                AttributeModifier raceStat = attribute.m_22111_((UUID)map.getValue().getLeft());
                if (raceStat != null) {
                    value += raceStat.m_22218_();
                }
            }
            if (map.getKey().equals(Attributes.f_22279_) && !(target instanceof Player)) {
                value = value / 0.23 * 0.1;
            } else if (map.getKey().equals(Attributes.f_22281_) && !this.isOwnClone(owner, target)) {
                value = Math.min(value, (Double)TensuraConfig.INSTANCE.racesConfig.maxAttackPossession.get());
            } else if (map.getKey().equals(Attributes.f_22276_) && !this.isOwnClone(owner, target)) {
                value = Math.min(value, (Double)TensuraConfig.INSTANCE.racesConfig.maxHeathPossession.get());
            }
            AttributeModifierHelper.setModifier((LivingEntity)owner, (Attribute)map.getKey(), (AttributeModifier)new AttributeModifier((UUID)map.getValue().getLeft(), (String)map.getValue().getMiddle(), value - owner.m_21172_(map.getKey()), AttributeModifier.Operation.ADDITION));
        }
        AttributeInstance jumpStrength = target.m_21051_(Attributes.f_22288_);
        if (jumpStrength == null) {
            AttributeInstance jumpPower = target.m_21051_((Attribute)ManasCoreAttributes.JUMP_POWER.get());
            if (jumpPower == null) {
                jump = 0.42;
            } else {
                jump = target.m_21172_((Attribute)ManasCoreAttributes.JUMP_POWER.get());
                AttributeModifier raceStat = jumpPower.m_22111_(TensuraAttributeModifierIds.RACE_JUMP_HEIGHT_MODIFIER_ID);
                if (raceStat != null) {
                    jump += raceStat.m_22218_();
                }
            }
        } else {
            jump = Math.max(target.m_21172_(Attributes.f_22288_) / 0.7 * 0.42, 0.42);
        }
        AttributeModifierHelper.setModifier((LivingEntity)owner, (Attribute)((Attribute)ManasCoreAttributes.JUMP_POWER.get()), (AttributeModifier)new AttributeModifier(TensuraAttributeModifierIds.RACE_JUMP_HEIGHT_MODIFIER_ID, "tensura:race_jump_power", jump - owner.m_21172_((Attribute)ManasCoreAttributes.JUMP_POWER.get()), AttributeModifier.Operation.ADDITION));
    }

    public boolean isOwnClone(LivingEntity owner, LivingEntity target) {
        CloneEntity clone;
        return target instanceof CloneEntity && (clone = (CloneEntity)target).m_21830_(owner);
    }

    private Map<Attribute, Triple<UUID, String, Double>> getStatList() {
        return Map.of(Attributes.f_22276_, Triple.of((Object)TensuraAttributeModifierIds.RACE_BASE_HEALTH_MODIFIER_ID, (Object)"tensura:race_base_health", (Object)1.0), Attributes.f_22281_, Triple.of((Object)TensuraAttributeModifierIds.RACE_ATTACK_DAMAGE_MODIFIER_ID, (Object)"tensura:race_attack_damage", (Object)0.1), Attributes.f_22278_, Triple.of((Object)TensuraAttributeModifierIds.RACE_KNOCKBACK_RESISTANCE_MODIFIER_ID, (Object)"tensura:race_knockback_resistance", (Object)0.0), Attributes.f_22279_, Triple.of((Object)TensuraAttributeModifierIds.RACE_MOVEMENT_SPEED_MODIFIER_ID, (Object)"tensura:race_movement_speed", (Object)0.1));
    }
}

