/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.intrinsic;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.capability.race.ITensuraPlayerCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.handler.CapabilityHandler;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class EyeOfTruthSkill
extends Skill {
    public static final ImmutableList<MobEffect> VISION = ImmutableList.of((Object)MobEffects.f_19610_, (Object)MobEffects.f_19604_, (Object)MobEffects.f_216964_);

    public EyeOfTruthSkill() {
        super(Skill.SkillType.INTRINSIC);
    }

    @Override
    public boolean meetEPRequirement(Player entity, double newEP) {
        ITensuraPlayerCapability cap = CapabilityHandler.getCapability((Entity)entity, TensuraPlayerCapability.CAPABILITY);
        if (cap == null) {
            return false;
        }
        return cap.isHeroEgg() || cap.isTrueHero();
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return true;
        }
        Player player = (Player)entity;
        ITensuraPlayerCapability cap = CapabilityHandler.getCapability((Entity)player, TensuraPlayerCapability.CAPABILITY);
        if (cap == null) {
            return false;
        }
        return cap.isHeroEgg() || cap.isTrueHero();
    }

    @Override
    public boolean canBeSlotted(ManasSkillInstance instance) {
        return instance.getMastery() < 0;
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        return instance.isToggled();
    }

    public void onTick(ManasSkillInstance instance, LivingEntity entity) {
        CompoundTag tag = instance.getOrCreateTag();
        int time = tag.m_128451_("activatedTimes");
        if (time % 10 == 0) {
            this.addMasteryPoint(instance, entity);
        }
        tag.m_128405_("activatedTimes", time + 1);
        entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.PRESENCE_SENSE.get(), 200, 3, false, false, false));
    }

    @Override
    @NotNull
    public List<MobEffect> getImmuneEffects(ManasSkillInstance instance, LivingEntity entity) {
        if (!instance.isToggled()) {
            return new ArrayList<MobEffect>();
        }
        return VISION;
    }

    public void onToggleOn(ManasSkillInstance instance, LivingEntity entity) {
        SkillHelper.removePredicateEffect(entity, arg_0 -> VISION.contains(arg_0));
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11862_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public void onToggleOff(ManasSkillInstance instance, LivingEntity entity) {
        int level;
        if (entity.m_21023_((MobEffect)TensuraMobEffects.PRESENCE_SENSE.get()) && (level = Objects.requireNonNull(entity.m_21124_((MobEffect)TensuraMobEffects.PRESENCE_SENSE.get())).m_19564_()) == 3) {
            entity.m_21195_((MobEffect)TensuraMobEffects.PRESENCE_SENSE.get());
        }
    }
}

