/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.intrinsic;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.entity.magic.beam.BeamProjectile;
import com.github.manasmods.tensura.entity.magic.field.cloud.BloodMistCloud;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;

public class BloodMistSkill
extends Skill {
    public BloodMistSkill() {
        super(Skill.SkillType.INTRINSIC);
    }

    @Override
    public boolean canInteractSkill(ManasSkillInstance instance, LivingEntity entity) {
        Player player;
        if (entity instanceof Player && TensuraPlayerCapability.isSpiritualForm(player = (Player)entity)) {
            return false;
        }
        return super.canInteractSkill(instance, entity);
    }

    @Override
    public int modes() {
        return 2;
    }

    @Override
    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (instance.getMode() == 1) {
            if (!instance.isMastered(entity)) {
                return 0;
            }
            if (TensuraEPCapability.getEP(entity) < 500000.0) {
                return 0;
            }
            return 2;
        }
        return 1;
    }

    @Override
    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"tensura.skill.mode.default");
            case 2 -> Component.m_237115_((String)"tensura.skill.mode.blood_mist.ray");
            default -> Component.m_237119_();
        };
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        if (instance.getMode() == 2) {
            return 10000.0;
        }
        return 500.0;
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (instance.getMode() != 2) {
            return false;
        }
        if (heldTicks % 10 == 0) {
            Player player;
            if (SkillHelper.outOfMagicule(entity, instance)) {
                return false;
            }
            if (!(entity instanceof Player) || !(player = (Player)entity).m_7500_()) {
                entity.m_6469_(TensuraDamageSources.BLOOD_DRAIN.m_19382_().m_19381_(), 10.0f);
            }
        }
        double cost = this.magiculeCost(entity, instance);
        BeamProjectile.spawnLastingBeam((EntityType<? extends BeamProjectile>)((EntityType)TensuraEntityTypes.BLOOD_RAY.get()), 50.0f, 0.2f, 21, 40.0f, 0.0f, entity.m_146892_(), entity, instance, cost, cost, heldTicks);
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_215771_, SoundSource.PLAYERS, 0.8f, 0.5f);
        return true;
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        AABB aabb;
        List list;
        Level level = entity.m_9236_();
        CompoundTag tag = instance.getOrCreateTag();
        if (instance.getMode() == 2) {
            tag.m_128405_("BeamID", 0);
            instance.markDirty();
            return;
        }
        if (tag.m_128441_("mistY") && !(list = level.m_6443_(BloodMistCloud.class, aabb = new AABB(new BlockPos(tag.m_128459_("mistX"), tag.m_128459_("mistY"), tag.m_128459_("mistZ"))).m_82400_(0.5), mist -> mist.m_37282_() == entity)).isEmpty()) {
            entity.m_21011_(InteractionHand.MAIN_HAND, true);
            for (BloodMistCloud mist2 : list) {
                mist2.bloodExplosion();
            }
            tag.m_128473_("mistX");
            tag.m_128473_("mistY");
            tag.m_128473_("mistZ");
            instance.markDirty();
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11862_, SoundSource.PLAYERS, 1.0f, 1.0f);
            instance.setCoolDown(instance.isMastered(entity) ? 2 : 3);
            return;
        }
        BlockHitResult result = SkillHelper.getPlayerPOVHitResult(level, (Entity)entity, ClipContext.Fluid.NONE, 10.0);
        BlockPos pos = result.m_82425_();
        this.addMasteryPoint(instance, entity);
        BloodMistCloud mist3 = new BloodMistCloud(entity.m_9236_(), entity);
        mist3.setDamage(10.0f);
        mist3.setRadius(5.0f);
        mist3.setHeight(1.0f);
        mist3.setSkill(instance);
        mist3.setMpCost(500.0);
        mist3.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_() + 1, (double)pos.m_123343_() + 0.5);
        level.m_7967_((Entity)mist3);
        entity.m_6469_(TensuraDamageSources.BLOOD_DRAIN.m_19382_(), 20.0f);
        entity.m_21011_(InteractionHand.MAIN_HAND, true);
        tag.m_128347_("mistX", mist3.m_20185_());
        tag.m_128347_("mistY", mist3.m_20186_());
        tag.m_128347_("mistZ", mist3.m_20189_());
        instance.markDirty();
        level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12049_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }
}

