/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.intrinsic;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.capability.effects.TensuraEffectsCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.race.slime.SlimeRace;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.items.TensuraConsumableItems;
import com.github.manasmods.tensura.registry.items.TensuraMaterialItems;
import com.github.manasmods.tensura.registry.items.TensuraMobDropItems;
import com.github.manasmods.tensura.util.TensuraAdvancementsHelper;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class AbsorbDissolveSkill
extends Skill {
    public AbsorbDissolveSkill() {
        super(Skill.SkillType.INTRINSIC);
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        ItemStack itemStack = entity.m_21205_();
        for (Dissolving dissolving : Dissolving.values()) {
            if (!dissolving.getItem().equals(itemStack.m_41720_())) continue;
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                if (itemStack.m_41720_().equals(TensuraMaterialItems.SLIME_IN_A_BUCKET.get())) {
                    TensuraAdvancementsHelper.grant(serverPlayer, TensuraAdvancementsHelper.Advancements.TRAITOR);
                }
                serverPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)itemStack.m_41720_()));
            }
            if (entity instanceof Player) {
                Player player = (Player)entity;
                TensuraPlayerCapability.getFrom(player).ifPresent(cap -> {
                    double magicule = cap.getMagicule();
                    double max = player.m_21133_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get());
                    double newMagicule = magicule + (double)dissolving.getMagicule();
                    cap.setMagicule(magicule > max ? newMagicule : Math.min(max, newMagicule));
                });
                TensuraPlayerCapability.sync(player);
            }
            if (dissolving.getHeal() > 0.0f) {
                entity.m_5634_(dissolving.getHeal());
            }
            if (itemStack.m_41720_().equals(TensuraMobDropItems.SLIME_CORE.get()) && TensuraPlayerCapability.getRace(entity) instanceof SlimeRace) {
                TensuraEffectsCapability.getFrom(entity).ifPresent(cap -> {
                    if (cap.getHeight() == 0.0f) {
                        cap.setHeight(1.0f);
                    }
                    if (entity.m_6144_()) {
                        if (cap.getHeight() <= 1.0f) {
                            return;
                        }
                        cap.setHeight(cap.getHeight() - 0.2f);
                        TensuraEffectsCapability.sync(entity);
                    } else {
                        if (cap.getHeight() >= 3.0f) {
                            return;
                        }
                        cap.setHeight(cap.getHeight() + 0.2f);
                        TensuraEffectsCapability.sync(entity);
                    }
                });
            }
            itemStack.m_41774_(1);
            this.addMasteryPoint(instance, entity);
            entity.m_21011_(InteractionHand.MAIN_HAND, true);
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12321_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public static enum Dissolving {
        ADAMANTITE_INGOT((Item)TensuraMaterialItems.ADAMANTITE_INGOT.get(), 100000, 0.0f),
        ARMORSAURUS_SCALE((Item)TensuraMobDropItems.ARMOURSAURUS_SCALE.get(), 50, 0.0f),
        ARMORSAURUS_SHELL((Item)TensuraMobDropItems.ARMOURSAURUS_SHELL.get(), 150, 0.0f),
        CHARYBDIS_SCALE((Item)TensuraMobDropItems.CHARYBDIS_SCALE.get(), 300, 0.0f),
        GEHENNA_SILK((Item)TensuraMobDropItems.GEHENNA_MOTH_SILK.get(), 50, 0.0f),
        ANT_CARAPACE((Item)TensuraMobDropItems.GIANT_ANT_CARAPACE.get(), 120, 0.0f),
        ANT_LEG((Item)TensuraConsumableItems.GIANT_ANT_LEG.get(), 60, 5.0f),
        BAT_WING((Item)TensuraMobDropItems.GIANT_BAT_WING.get(), 400, 2.0f),
        BEAST_HORN((Item)TensuraMobDropItems.BEAST_HORN.get(), 200, 2.0f),
        BLADE_TIGER_TAIL((Item)TensuraMobDropItems.BLADE_TIGER_TAIL.get(), 500, 2.0f),
        HELL_SILK((Item)TensuraMobDropItems.HELL_MOTH_SILK.get(), 10, 0.0f),
        HIHIIROKANE_INGOT((Item)TensuraMaterialItems.HIHIIROKANE_INGOT.get(), 400000, 0.0f),
        HMS_INGOT((Item)TensuraMaterialItems.HIGH_MAGISTEEL_INGOT.get(), 5000, 0.0f),
        HIGH_CRYSTAL((Item)TensuraMobDropItems.HIGH_QUALITY_MAGIC_CRYSTAL.get(), 5000, 0.0f),
        INSECTAR_CARAPACE((Item)TensuraMobDropItems.INSECTAR_CARAPACE.get(), 1200, 0.0f),
        INVISIBLE_FEATHER((Item)TensuraMobDropItems.INVISIBLE_FEATHER.get(), 10, 0.0f),
        SPIDER_CARAPACE((Item)TensuraMobDropItems.KNIGHT_SPIDER_CARAPACE.get(), 300, 0.0f),
        SPIDER_LEG((Item)TensuraConsumableItems.KNIGHT_SPIDER_LEG.get(), 100, 5.0f),
        LMS_INGOT((Item)TensuraMaterialItems.LOW_MAGISTEEL_INGOT.get(), 1000, 0.0f),
        LOW_CRYSTAL((Item)TensuraMobDropItems.LOW_QUALITY_MAGIC_CRYSTAL.get(), 1000, 0.0f),
        MAGIC_ORE((Item)TensuraMaterialItems.MAGIC_ORE.get(), 5000, 0.0f),
        MAGIC_STONE((Item)TensuraMaterialItems.MAGIC_STONE.get(), 1000, 0.0f),
        MEGALODON_MEAT((Item)TensuraConsumableItems.RAW_MEGALODON_MEAT.get(), 100, 5.0f),
        MITHRIL_INGOT((Item)TensuraMaterialItems.MITHRIL_INGOT.get(), 7500, 0.0f),
        LEATHER_A((Item)TensuraMobDropItems.MONSTER_LEATHER_A.get(), 1000, 0.0f),
        LEATHER_B((Item)TensuraMobDropItems.MONSTER_LEATHER_B.get(), 600, 0.0f),
        LEATHER_C((Item)TensuraMobDropItems.MONSTER_LEATHER_C.get(), 300, 0.0f),
        LEATHER_D((Item)TensuraMobDropItems.MONSTER_LEATHER_D.get(), 100, 0.0f),
        LEATHER_SA((Item)TensuraMobDropItems.MONSTER_LEATHER_SPECIAL_A.get(), 10000, 0.0f),
        MID_CRYSTAL((Item)TensuraMobDropItems.MEDIUM_QUALITY_MAGIC_CRYSTAL.get(), 2500, 0.0f),
        ORICHALCUM_INGOT((Item)TensuraMaterialItems.ORICHALCUM_INGOT.get(), 7500, 0.0f),
        PEACOCK_FEATHER((Item)TensuraMobDropItems.DRAGON_PEACOCK_FEATHER.get(), 10, 0.0f),
        PMS_INGOT((Item)TensuraMaterialItems.PURE_MAGISTEEL_INGOT.get(), 10000, 0.0f),
        SERPENT_SCALE((Item)TensuraMobDropItems.SERPENT_SCALE.get(), 100, 0.0f),
        SISSIE_FIN((Item)TensuraConsumableItems.SISSIE_FIN.get(), 3000, 5.0f),
        SPIDER_FANG((Item)TensuraMobDropItems.SPIDER_FANG.get(), 600, 0.0f),
        STEEL_THREAD((Item)TensuraMobDropItems.STEEL_THREAD.get(), 10, 0.0f),
        STICKY_THREAD((Item)TensuraMobDropItems.STICKY_THREAD.get(), 10, 0.0f),
        SLIME_BUCKET((Item)TensuraMaterialItems.SLIME_IN_A_BUCKET.get(), 0, 0.0f),
        SLIME_CORE((Item)TensuraMobDropItems.SLIME_CORE.get(), 50000, 0.0f),
        UNICORN_HORN((Item)TensuraMobDropItems.UNICORN_HORN.get(), 600, 10.0f),
        DEMON_ESSENCE((Item)TensuraMobDropItems.DEMON_ESSENCE.get(), 3000, 5.0f),
        DRAGON_ESSENCE((Item)TensuraMobDropItems.DRAGON_ESSENCE.get(), 5000, 6.0f),
        ELEMENTAL_ESSENCE((Item)TensuraMobDropItems.ELEMENTAL_ESSENCE.get(), 2000, 4.0f),
        ROYAL_BLOOD((Item)TensuraMobDropItems.ROYAL_BLOOD.get(), 1000, 3.0f),
        ZANE_BLOOD((Item)TensuraMobDropItems.ZANE_BLOOD.get(), 5000, 6.0f);

        private final Item item;
        private final int magicule;
        private final float heal;

        public Item getItem() {
            return this.item;
        }

        public int getMagicule() {
            return this.magicule;
        }

        public float getHeal() {
            return this.heal;
        }

        private Dissolving(Item item, int magicule, float heal) {
            this.item = item;
            this.magicule = magicule;
            this.heal = heal;
        }
    }
}

