/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.extra;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2client.RequestFxSpawningPacket;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;

public class WeatherDominationSkill
extends Skill {
    public WeatherDominationSkill() {
        super(Skill.SkillType.EXTRA);
    }

    @Override
    public boolean meetEPRequirement(Player entity, double newEP) {
        if (!SkillUtils.isSkillMastered((LivingEntity)entity, (ManasSkill)ExtraSkills.WEATHER_MANIPULATION.get())) {
            return false;
        }
        return newEP > 400000.0;
    }

    @Override
    public double learningCost() {
        return 500.0;
    }

    @Override
    public int modes() {
        return 2;
    }

    @Override
    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return instance.getMode() == 1 ? 3 : instance.getMode() - 1;
        }
        return instance.getMode() == 3 ? 1 : instance.getMode() + 1;
    }

    @Override
    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"tensura.skill.mode.weather_manipulation.clear");
            case 2 -> Component.m_237115_((String)"tensura.skill.mode.weather_manipulation.rain");
            case 3 -> Component.m_237115_((String)"tensura.skill.mode.weather_manipulation.thunder");
            default -> Component.m_237119_();
        };
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 500.0;
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        if (!(instance instanceof TensuraSkillInstance)) {
            return;
        }
        TensuraSkillInstance skillInstance = (TensuraSkillInstance)instance;
        Level level = entity.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        if (!entity.f_19853_.m_46472_().equals((Object)Level.f_46428_)) {
            return;
        }
        if (SkillHelper.outOfMagicule(entity, skillInstance)) {
            return;
        }
        boolean sucess = false;
        switch (skillInstance.getMode()) {
            case 1: {
                if (!level2.m_46471_() && !level2.m_46470_()) break;
                level2.m_8606_(24000, 0, false, false);
                sucess = true;
                break;
            }
            case 2: {
                if (level2.m_46471_() && !level2.m_46470_()) break;
                level2.m_8606_(0, 24000, true, false);
                sucess = true;
                break;
            }
            case 3: {
                if (level2.m_46470_()) break;
                level2.m_8606_(0, 24000, true, true);
                sucess = true;
            }
        }
        if (sucess) {
            this.addMasteryPoint(instance, entity);
            instance.setCoolDown(instance.isMastered(entity) ? 3 : 5);
            entity.m_21011_(InteractionHand.MAIN_HAND, true);
            level2.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11736_, SoundSource.PLAYERS, 0.5f, 1.0f);
            TensuraNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new RequestFxSpawningPacket(new ResourceLocation("tensura:weather_manipulation"), entity.m_19879_(), 0.0, entity.m_20192_(), 0.0, true));
        }
    }
}

