/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.extra;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.api.entity.subclass.IElementalSpirit;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.effect.template.MobEffectHelper;
import com.github.manasmods.tensura.race.RaceHelper;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.enchantment.TensuraEnchantments;
import com.github.manasmods.tensura.registry.items.TensuraMaterialItems;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ShadowMotionSkill
extends Skill {
    public ShadowMotionSkill() {
        super(Skill.SkillType.EXTRA);
    }

    @Override
    public double learningCost() {
        return 200.0;
    }

    @Override
    public int modes() {
        return 3;
    }

    @Override
    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (!instance.isMastered(entity)) {
            if (instance.getMode() == 1) {
                return 0;
            }
            return 1;
        }
        if (reverse) {
            return instance.getMode() == 1 ? 3 : instance.getMode() - 1;
        }
        return instance.getMode() == 3 ? 1 : instance.getMode() + 1;
    }

    @Override
    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"tensura.skill.mode.shadow_motion.default");
            case 2 -> Component.m_237115_((String)"tensura.skill.mode.shadow_motion.step");
            case 3 -> Component.m_237115_((String)"tensura.skill.mode.shadow_motion.storage");
            default -> Component.m_237119_();
        };
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 2 -> 200.0;
            case 1 -> 10.0;
            default -> 0.0;
        };
    }

    @Override
    public boolean canInteractSkill(ManasSkillInstance instance, LivingEntity entity) {
        if (entity.m_21023_((MobEffect)TensuraMobEffects.SLEEP_MODE.get())) {
            return false;
        }
        if (entity.m_21023_((MobEffect)TensuraMobEffects.INFINITE_IMPRISONMENT.get())) {
            return false;
        }
        if (entity.m_21023_((MobEffect)TensuraMobEffects.SHADOW_STEP.get())) {
            return true;
        }
        return super.canInteractSkill(instance, entity);
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        Level level = entity.m_9236_();
        if (instance.getMode() != 1) {
            return false;
        }
        if (MobEffectHelper.noTeleportation(entity)) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237115_((String)"tensura.skill.spatial_blockade").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return false;
        }
        if (heldTicks <= 2) {
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_123765_, 1.0);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_123765_, 2.0);
        }
        if (level.m_46803_(entity.m_20183_()) <= 10 || this.isMastered(instance, entity) || entity.m_21023_((MobEffect)TensuraMobEffects.SHADOW_STEP.get())) {
            if (heldTicks % 20 == 0 && SkillHelper.outOfMagicule(entity, instance)) {
                return false;
            }
            if (heldTicks % 100 == 0 && heldTicks > 0) {
                this.addMasteryPoint(instance, entity);
            }
            if (ShadowMotionSkill.shouldConsumeAir(entity)) {
                entity.m_20301_(entity.m_20146_() - 1);
                if (entity.m_20146_() <= -20) {
                    entity.m_20301_(0);
                    entity.m_6469_(TensuraDamageSources.SUFFOCATE, 1.0f);
                }
            }
            entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.SHADOW_STEP.get(), 5, 0, false, false, false));
        }
        return true;
    }

    private boolean canShadowStorage(LivingEntity target, LivingEntity entity) {
        IElementalSpirit spirit;
        if (target instanceof Player) {
            return false;
        }
        if (!SkillHelper.isSubordinate(entity, target)) {
            return false;
        }
        if (target instanceof IElementalSpirit && (spirit = (IElementalSpirit)target).getSummoningTick() > 0) {
            return false;
        }
        if (target.m_6095_().m_204039_(TensuraTags.EntityTypes.MONSTER)) {
            return true;
        }
        return !ShadowMotionSkill.shouldConsumeAir(target);
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        if (instance.getMode() == 1) {
            return;
        }
        if (MobEffectHelper.noTeleportation(entity)) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237115_((String)"tensura.skill.spatial_blockade").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return;
        }
        Level level = entity.m_9236_();
        if (instance.getMode() == 3) {
            Player player;
            LivingEntity target = SkillHelper.getTargetingEntity(entity, 5.0, false);
            if (target == null) {
                if (entity instanceof Player) {
                    Player player2 = (Player)entity;
                    player2.m_5661_((Component)Component.m_237115_((String)"tensura.targeting.not_targeted").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                }
                return;
            }
            if (!this.canShadowStorage(target, entity)) {
                if (entity instanceof Player) {
                    Player player3 = (Player)entity;
                    player3.m_5661_((Component)Component.m_237115_((String)"tensura.targeting.not_allowed").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                }
                return;
            }
            level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12052_, SoundSource.PLAYERS, 1.0f, 1.0f);
            ItemStack shadow = new ItemStack((ItemLike)TensuraMaterialItems.SHADOW_STORAGE.get());
            shadow.m_41714_((Component)Component.m_237110_((String)"tooltip.tensura.shadow_storage.name", (Object[])new Object[]{target.m_7755_()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)));
            CompoundTag compound = shadow.m_41784_();
            compound.m_128365_("ShadowData", (Tag)target.serializeNBT());
            compound.m_128347_("ShadowEP", TensuraEPCapability.getEP(target));
            compound.m_128347_("ShadowHP", (double)target.m_21223_());
            compound.m_128347_("ShadowSHP", TensuraEPCapability.getSpiritualHealth(target));
            compound.m_128359_("EntityType", String.valueOf(Registry.f_122826_.m_7981_((Object)target.m_6095_())));
            if (!(entity instanceof Player) || !(player = (Player)entity).m_36356_(shadow)) {
                SkillHelper.dropItem((Entity)entity, entity.m_217043_(), shadow, 10, 0.5f);
            }
            target.m_146870_();
            return;
        }
        if (SkillHelper.outOfMagicule(entity, instance)) {
            return;
        }
        LivingEntity target = SkillHelper.getTargetingEntity(entity, 20.0, false);
        if (target == null || !target.m_6084_()) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237115_((String)"tensura.targeting.not_targeted").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            }
            return;
        }
        float radius = -1.5f;
        float angle = (float)Math.PI / 180 * target.f_20885_;
        double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.m_14089_((float)angle);
        BlockPos behindPos = new BlockPos(target.m_20185_() + extraX, target.m_20186_(), target.m_20189_() + extraZ);
        if (level.m_8055_(behindPos).m_60804_((BlockGetter)level, behindPos) && level.m_8055_(behindPos.m_7494_()).m_60804_((BlockGetter)level, behindPos.m_7494_())) {
            behindPos = target.m_20183_();
        }
        SkillHelper.removeSpecificTargetInRadius((Entity)entity, 40.0, mob -> true);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_123765_, 1.0, 10);
        entity.m_19877_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            double d0 = target.m_20185_() - (double)behindPos.m_123341_();
            double d2 = target.m_20189_() - (double)behindPos.m_123343_();
            float yRot = Mth.m_14177_((float)((float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f));
            player.m_8999_((ServerLevel)level, (double)behindPos.m_123341_(), (double)behindPos.m_123342_(), (double)behindPos.m_123343_(), yRot, entity.m_146909_());
        } else {
            entity.m_20324_((double)behindPos.m_123341_(), (double)behindPos.m_123342_(), (double)behindPos.m_123343_());
        }
        entity.f_19812_ = true;
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_123765_, 1.0);
        level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12052_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public static boolean shouldConsumeAir(LivingEntity entity) {
        Player player;
        if (TensuraEPCapability.isMajin(entity)) {
            return false;
        }
        if (RaceHelper.isSpiritualLifeForm(entity)) {
            return false;
        }
        if (entity.m_6844_(EquipmentSlot.HEAD).getEnchantmentLevel((Enchantment)TensuraEnchantments.BREATHING_SUPPORT.get()) >= 1) {
            return false;
        }
        if (entity instanceof Player && (player = (Player)entity).m_7500_()) {
            return false;
        }
        return !entity.m_5833_();
    }
}

