/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.extra;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.extra.HakiSkill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2client.RequestFxSpawningPacket;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraftforge.network.PacketDistributor;

public class MortalFearSkill
extends Skill {
    private static final String HAKI = "52863491-edf5-4226-8fcc-c4e42a519af1";

    public MortalFearSkill() {
        super(Skill.SkillType.EXTRA);
        this.addHeldAttributeModifier(Attributes.f_22279_, HAKI, -0.95f, AttributeModifier.Operation.MULTIPLY_TOTAL);
    }

    @Override
    public double learningCost() {
        return 500.0;
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 50.0;
    }

    public double getAttributeModifierAmplifier(ManasSkillInstance instance, LivingEntity entity, AttributeModifier modifier) {
        return modifier.m_22218_() * (instance.isMastered(entity) ? 0.9473684210526315 : 1.0);
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        Level level = entity.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (heldTicks % 100 == 0 && heldTicks > 0) {
            this.addMasteryPoint(instance, entity);
        }
        double scale = instance.getTag() == null ? 0.0 : instance.getTag().m_128459_("scale");
        double multiplier = scale == 0.0 ? 1.0 : Math.min(scale, 1.0);
        double ownerEP = TensuraEPCapability.getEP(entity) * multiplier;
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11862_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        List list = serverLevel.m_143280_(EntityTypeTest.m_156916_(LivingEntity.class), living -> SkillHelper.isSubordinate(entity, living));
        if (!list.isEmpty()) {
            if (heldTicks % 20 == 0 && SkillHelper.outOfMagicule(entity, this.magiculeCost(entity, instance) * (double)list.size())) {
                return false;
            }
            if (heldTicks % 5 == 0) {
                TensuraNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new RequestFxSpawningPacket(new ResourceLocation("tensura:mortal_fear"), entity.m_19879_(), 0.0, 1.0, 0.0, true));
            }
            this.mortalFear(list, entity, heldTicks, ownerEP, 5.0, instance.isMastered(entity));
        } else {
            if (heldTicks % 20 == 0 && SkillHelper.outOfMagicule(entity, instance)) {
                return false;
            }
            this.mortalFear(List.of(entity), entity, heldTicks, ownerEP, 10.0, instance.isMastered(entity));
            if (heldTicks % 5 == 0) {
                TensuraNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new RequestFxSpawningPacket(new ResourceLocation("tensura:sub_mortal_fear"), entity.m_19879_(), 0.0, 1.0, 0.0, true));
            }
        }
        return true;
    }

    public void onRelease(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (!this.hasAttributeApplied(entity, Attributes.f_22279_, HAKI)) {
            return;
        }
        instance.setCoolDown(instance.isMastered(entity) ? 3 : 5);
    }

    private void mortalFear(List<? extends LivingEntity> list, LivingEntity entity, int heldTicks, double EP, double radius, boolean mastered) {
        for (LivingEntity livingEntity : list) {
            List targetList;
            if (livingEntity != entity && heldTicks % 5 == 0) {
                TensuraNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> subordinate), (Object)new RequestFxSpawningPacket(new ResourceLocation("tensura:sub_mortal_fear"), livingEntity.m_19879_(), 0.0, 1.0, 0.0, true));
            }
            if (livingEntity != entity) {
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 1200, mastered ? 7 : 3, false, true));
            }
            if ((targetList = entity.m_9236_().m_6443_(LivingEntity.class, livingEntity.m_20191_().m_82400_(radius), entityData -> entityData.m_6084_() && !entityData.m_7307_((Entity)entity) && !entityData.m_7306_((Entity)entity))).isEmpty()) continue;
            for (LivingEntity target : targetList) {
                double targetEP;
                double difference;
                if (target instanceof Player) {
                    Player player = (Player)target;
                    if (player.m_150110_().f_35934_) continue;
                }
                if ((difference = EP / (targetEP = TensuraEPCapability.getEP(target))) <= 2.0) continue;
                int fearLevel = (int)(difference * 0.25 - 0.5);
                fearLevel = Math.min(fearLevel, (Integer)TensuraConfig.INSTANCE.mobEffectConfig.maxFear.get());
                SkillHelper.checkThenAddEffectSource(target, (Entity)entity, (MobEffect)TensuraMobEffects.FEAR.get(), 200, fearLevel);
                HakiSkill.hakiPush(target, entity, fearLevel);
            }
        }
    }

    public void onScroll(ManasSkillInstance instance, LivingEntity entity, double delta) {
        HakiSkill.changeEPUsed(instance, entity, delta);
    }
}

