/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.extra;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.extra.HakiSkill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2client.RequestFxSpawningPacket;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.PacketDistributor;

public class HeroHakiSkill
extends Skill {
    private static final String HAKI = "bc1c5f82-48cf-43f5-89f7-d4c898fcc171";

    public HeroHakiSkill() {
        super(Skill.SkillType.EXTRA);
        this.addHeldAttributeModifier(Attributes.f_22279_, HAKI, -0.95f, AttributeModifier.Operation.MULTIPLY_TOTAL);
    }

    @Override
    public boolean meetEPRequirement(Player entity, double newEP) {
        if (TensuraEPCapability.isMajin((LivingEntity)entity) && !TensuraEPCapability.isChaos((LivingEntity)entity)) {
            return false;
        }
        if (!SkillUtils.hasSkill((Entity)entity, (ManasSkill)ExtraSkills.HAKI.get())) {
            return false;
        }
        return newEP > 200000.0;
    }

    @Override
    public double learningCost() {
        return 500.0;
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 25.0;
    }

    public void onSkillMastered(ManasSkillInstance instance, LivingEntity entity) {
        Player player;
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        if (entity instanceof Player && TensuraPlayerCapability.isTrueHero((LivingEntity)(player = (Player)entity))) {
            ManasSkill skill = (ManasSkill)ExtraSkills.SACRED_HAKI.get();
            TensuraSkillInstance sacred = new TensuraSkillInstance(skill);
            sacred.setMastery(-100);
            if (storage.learnSkill((ManasSkillInstance)sacred)) {
                player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.learn_available", (Object[])new Object[]{skill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN)), false);
            }
        }
    }

    public double getAttributeModifierAmplifier(ManasSkillInstance instance, LivingEntity entity, AttributeModifier modifier) {
        return modifier.m_22218_() * (instance.isMastered(entity) ? 0.9473684210526315 : 1.0);
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (heldTicks % 20 == 0 && SkillHelper.outOfMagicule(entity, instance)) {
            return false;
        }
        if (heldTicks % 60 == 0 && heldTicks > 0) {
            this.addMasteryPoint(instance, entity);
        }
        HeroHakiSkill.activateHeroHaki(instance, entity, heldTicks);
        return true;
    }

    public void onRelease(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (!this.hasAttributeApplied(entity, Attributes.f_22279_, HAKI)) {
            return;
        }
        instance.setCoolDown(instance.isMastered(entity) ? 3 : 5);
    }

    public static void activateHeroHaki(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        List list;
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12362_, SoundSource.PLAYERS, 1.0f, 1.0f);
        if (heldTicks % 2 == 0) {
            TensuraNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new RequestFxSpawningPacket(new ResourceLocation("tensura:hero_haki"), entity.m_19879_(), 0.0, 1.0, 0.0, true));
        }
        if (!(list = entity.m_9236_().m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(15.0), entityData -> !entityData.m_7306_((Entity)entity) && entityData.m_6084_() && !entityData.m_7307_((Entity)entity))).isEmpty()) {
            double scale = instance.getTag() == null ? 0.0 : instance.getTag().m_128459_("scale");
            double multiplier = scale == 0.0 ? 1.0 : Math.min(scale, 1.0);
            double ownerEP = TensuraEPCapability.getEP(entity) * multiplier;
            for (LivingEntity target : list) {
                double targetEP;
                double difference;
                if (target instanceof Player) {
                    Player player = (Player)target;
                    if (player.m_150110_().f_35934_) continue;
                }
                if ((difference = ownerEP / (targetEP = TensuraEPCapability.getEP(target))) <= 2.0) continue;
                int fearLevel = (int)(difference * 0.375 - 0.75);
                fearLevel = Math.min(fearLevel, (Integer)TensuraConfig.INSTANCE.mobEffectConfig.maxFear.get());
                SkillHelper.checkThenAddEffectSource(target, (Entity)entity, (MobEffect)TensuraMobEffects.FEAR.get(), 200, fearLevel);
                HakiSkill.hakiPush(target, entity, fearLevel);
            }
        }
    }

    public void onScroll(ManasSkillInstance instance, LivingEntity entity, double delta) {
        if (instance.getMode() != 1) {
            return;
        }
        HakiSkill.changeEPUsed(instance, entity, delta);
    }
}

