/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.extra;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.skill.CommonSkills;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class GravityManipulationSkill
extends Skill {
    public GravityManipulationSkill() {
        super(Skill.SkillType.EXTRA);
    }

    @Override
    public double learningCost() {
        return 1000.0;
    }

    @Override
    public boolean meetEPRequirement(Player entity, double newEP) {
        return GravityManipulationSkill.learnGravityManipulation((LivingEntity)entity);
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 0.0;
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return true;
    }

    public void onSkillMastered(ManasSkillInstance instance, LivingEntity entity) {
        if (TensuraEPCapability.getEP(entity) < 400000.0) {
            return;
        }
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        ManasSkill skill = (ManasSkill)ExtraSkills.GRAVITY_DOMINATION.get();
        TensuraSkillInstance manipulation = new TensuraSkillInstance(skill);
        manipulation.setMastery(-100);
        if (storage.learnSkill((ManasSkillInstance)manipulation) && entity instanceof Player) {
            Player player = (Player)entity;
            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.learn_available", (Object[])new Object[]{skill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN)), false);
        }
    }

    public void onDamageEntity(ManasSkillInstance instance, LivingEntity living, LivingHurtEvent e) {
        if (!instance.isToggled()) {
            return;
        }
        if (SkillUtils.isSkillToggled((Entity)living, (ManasSkill)ExtraSkills.GRAVITY_DOMINATION.get())) {
            return;
        }
        if (DamageSourceHelper.isGravityDamage(e.getSource())) {
            e.setAmount(e.getAmount() * 2.0f);
        }
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        if (entity.m_21023_((MobEffect)TensuraMobEffects.MAGIC_INTERFERENCE.get())) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237115_((String)"tensura.skill.magic_interference").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (player.m_7500_() || player.m_5833_()) {
            return;
        }
        if (SkillHelper.outOfMagicule((LivingEntity)player, instance)) {
            return;
        }
        if (player.m_150110_().f_35936_) {
            player.m_150110_().f_35936_ = false;
            player.m_150110_().f_35935_ = false;
        } else {
            this.addMasteryPoint(instance, entity);
            player.m_150110_().f_35936_ = true;
            player.m_150110_().f_35935_ = true;
        }
        player.m_6885_();
        player.m_6330_(SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public static boolean learnGravityManipulation(LivingEntity entity) {
        int skills = 0;
        for (ManasSkillInstance skill : SkillAPI.getSkillsFrom((Entity)entity).getLearnedSkills()) {
            if (!GravityManipulationSkill.isGravitySKill(skill, entity)) continue;
            ++skills;
        }
        return skills >= 3;
    }

    private static boolean isGravitySKill(ManasSkillInstance instance, LivingEntity entity) {
        if (!instance.isMastered(entity)) {
            return false;
        }
        if (instance.getSkill().equals(CommonSkills.GRAVITY_FIELD.get())) {
            return true;
        }
        return instance.getSkill().equals(CommonSkills.GRAVITY_FLIGHT.get());
    }
}

