/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.extra;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.extra.MolecularManipulationSkill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.skill.TensuraSkillCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.entity.magic.breath.BreathEntity;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import com.github.manasmods.tensura.registry.skill.IntrinsicSkills;
import com.github.manasmods.tensura.registry.skill.ResistanceSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class FlameManipulationSkill
extends Skill {
    public FlameManipulationSkill() {
        super(Skill.SkillType.EXTRA);
    }

    @Override
    public boolean meetEPRequirement(Player entity, double newEP) {
        return TensuraSkillCapability.getSpiritLevel(entity, MagicElemental.FLAME.getId()) >= 1;
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return true;
    }

    public void onSkillMastered(ManasSkillInstance instance, LivingEntity entity) {
        MolecularManipulationSkill.learnMolecular(entity);
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        ManasSkill skill = (ManasSkill)ExtraSkills.HEAT_WAVE.get();
        TensuraSkillInstance heatWave = new TensuraSkillInstance(skill);
        heatWave.setMastery(-100);
        if (storage.learnSkill((ManasSkillInstance)heatWave) && entity instanceof Player) {
            Player player = (Player)entity;
            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.learn_available", (Object[])new Object[]{skill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN)), false);
        }
        if (TensuraEPCapability.getEP(entity) < 400000.0) {
            return;
        }
        ManasSkill flame = (ManasSkill)ExtraSkills.FLAME_DOMINATION.get();
        TensuraSkillInstance manipulation = new TensuraSkillInstance(flame);
        manipulation.setMastery(-100);
        if (storage.learnSkill((ManasSkillInstance)manipulation) && entity instanceof Player) {
            Player player = (Player)entity;
            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.learn_available", (Object[])new Object[]{flame.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN)), false);
        }
    }

    public void onDamageEntity(ManasSkillInstance instance, LivingEntity living, LivingHurtEvent e) {
        if (!instance.isToggled()) {
            return;
        }
        if (SkillUtils.isSkillToggled((Entity)living, (ManasSkill)ExtraSkills.FLAME_DOMINATION.get())) {
            return;
        }
        if (DamageSourceHelper.isFireDamage(e.getSource())) {
            e.setAmount(e.getAmount() * 2.0f);
        }
    }

    public void onTouchEntity(ManasSkillInstance instance, LivingEntity attacker, LivingHurtEvent e) {
        if (!this.isInSlot(attacker)) {
            return;
        }
        if (!FlameManipulationSkill.canUseFire(attacker)) {
            return;
        }
        if (!DamageSourceHelper.isPhysicalAttack(e.getSource()) && !(e.getSource().m_7639_() instanceof AbstractArrow)) {
            return;
        }
        LivingEntity target = e.getEntity();
        target.m_20254_(this.isMastered(instance, attacker) ? 10 : 5);
        attacker.m_9236_().m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), SoundEvents.f_11909_, SoundSource.PLAYERS, 1.0f, 1.0f);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123744_, 1.0);
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        instance.getOrCreateTag().m_128405_("BreathEntity", 0);
        instance.markDirty();
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (!FlameManipulationSkill.canUseFire(entity)) {
            return false;
        }
        if (heldTicks % 60 == 0 && heldTicks > 0) {
            this.addMasteryPoint(instance, entity);
        }
        FlameManipulationSkill.spawnFlameBreath(entity, instance, this.magiculeCost(entity, instance));
        return true;
    }

    public static void spawnFlameBreath(LivingEntity entity, ManasSkillInstance instance, double cost) {
        EntityType entityType = (EntityType)TensuraEntityTypes.FLAME_BREATH.get();
        if (entity.m_21023_((MobEffect)TensuraMobEffects.BLACK_BURN.get())) {
            entityType = (EntityType)TensuraEntityTypes.BLACK_FLAME_BREATH.get();
        }
        float damage = instance.isMastered(entity) ? 20.0f : 8.0f;
        BreathEntity.spawnBreathEntity((EntityType<? extends BreathEntity>)entityType, entity, instance, damage, cost);
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11705_, SoundSource.PLAYERS, 1.0f, 1.0f);
        if (entity.m_21023_((MobEffect)TensuraMobEffects.BLACK_BURN.get())) {
            entity.m_21195_((MobEffect)TensuraMobEffects.BLACK_BURN.get());
        }
        entity.m_20095_();
    }

    public static boolean canUseFire(LivingEntity entity) {
        if (entity.m_6060_()) {
            return true;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return TensuraSkillCapability.getSpiritLevel(player, MagicElemental.FLAME.getId()) >= 1;
        }
        return false;
    }

    public static void learnFlameManipulation(ManasSkillInstance instance, LivingEntity entity) {
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        int skills = FlameManipulationSkill.isFlameSKill(instance) ? 1 : 0;
        for (ManasSkillInstance skill : storage.getLearnedSkills()) {
            if (!FlameManipulationSkill.isFlameSKill(skill)) continue;
            ++skills;
        }
        if (skills < 2) {
            return;
        }
        ManasSkill skill = (ManasSkill)ExtraSkills.FLAME_MANIPULATION.get();
        TensuraSkillInstance manipulation = new TensuraSkillInstance(skill);
        manipulation.setMastery(-100);
        if (storage.learnSkill((ManasSkillInstance)manipulation) && entity instanceof Player) {
            Player player = (Player)entity;
            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.learn_available", (Object[])new Object[]{skill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN)), false);
        }
    }

    private static boolean isFlameSKill(ManasSkillInstance instance) {
        if (instance.isTemporarySkill() || instance.getMastery() < 0) {
            return false;
        }
        if (instance.getSkill().equals(ExtraSkills.BLACK_FLAME.get())) {
            return true;
        }
        if (instance.getSkill().equals(ResistanceSkills.FLAME_ATTACK_RESISTANCE.get())) {
            return true;
        }
        if (instance.getSkill().equals(IntrinsicSkills.FLAME_BREATH.get())) {
            return true;
        }
        return instance.getSkill().equals(IntrinsicSkills.FLAME_TRANSFORM.get());
    }
}

