/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.extra;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.extra.FlameManipulationSkill;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class FlameDominationSkill
extends Skill {
    public FlameDominationSkill() {
        super(Skill.SkillType.EXTRA);
    }

    @Override
    public boolean meetEPRequirement(Player entity, double newEP) {
        if (!SkillUtils.isSkillMastered((LivingEntity)entity, (ManasSkill)ExtraSkills.FLAME_MANIPULATION.get())) {
            return false;
        }
        return newEP > 400000.0;
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return true;
    }

    public void onDamageEntity(ManasSkillInstance instance, LivingEntity living, LivingHurtEvent e) {
        if (!instance.isToggled()) {
            return;
        }
        if (DamageSourceHelper.isFireDamage(e.getSource())) {
            e.setAmount(e.getAmount() * 4.0f);
        }
    }

    public void onTouchEntity(ManasSkillInstance instance, LivingEntity attacker, LivingHurtEvent e) {
        if (!this.isInSlot(attacker)) {
            return;
        }
        if (!FlameManipulationSkill.canUseFire(attacker)) {
            return;
        }
        if (!DamageSourceHelper.isPhysicalAttack(e.getSource()) && !(e.getSource().m_7639_() instanceof AbstractArrow)) {
            return;
        }
        LivingEntity target = e.getEntity();
        target.m_20254_(this.isMastered(instance, attacker) ? 20 : 10);
        attacker.m_9236_().m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), SoundEvents.f_11909_, SoundSource.PLAYERS, 1.0f, 1.0f);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123744_, 1.0);
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (!FlameManipulationSkill.canUseFire(entity)) {
            return false;
        }
        if (heldTicks % 60 == 0 && heldTicks > 0) {
            this.addMasteryPoint(instance, entity);
        }
        FlameManipulationSkill.spawnFlameBreath(entity, instance, this.magiculeCost(entity, instance));
        return true;
    }
}

