/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.extra;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.entity.magic.breath.BreathEntity;
import com.github.manasmods.tensura.entity.magic.skill.BlackFlameBallProjectile;
import com.github.manasmods.tensura.entity.magic.skill.HellFlareProjectile;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import com.github.manasmods.tensura.registry.skill.CommonSkills;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import com.github.manasmods.tensura.registry.skill.IntrinsicSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class BlackFlameSkill
extends Skill {
    public BlackFlameSkill() {
        super(Skill.SkillType.EXTRA);
    }

    @Override
    public boolean meetEPRequirement(Player entity, double newEP) {
        if (!SkillUtils.hasSkill((Entity)entity, (ManasSkill)ExtraSkills.BLACK_LIGHTNING.get())) {
            return false;
        }
        if (!SkillUtils.hasSkill((Entity)entity, (ManasSkill)ExtraSkills.MOLECULAR_MANIPULATION.get())) {
            return false;
        }
        return SkillUtils.isSkillMastered((LivingEntity)entity, (ManasSkill)IntrinsicSkills.FLAME_TRANSFORM.get());
    }

    @Override
    public double learningCost() {
        return 1000.0;
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity living) {
        return true;
    }

    @Override
    public int modes() {
        return 4;
    }

    @Override
    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return switch (instance.getMode()) {
                case 4 -> {
                    if (this.canEquipHellFlare(entity)) {
                        yield 3;
                    }
                    yield 2;
                }
                case 3 -> 2;
                case 2 -> 1;
                case 1 -> {
                    if (instance.getOrCreateTag().m_128451_("HellFlare") >= 200) {
                        yield 4;
                    }
                    if (this.canEquipHellFlare(entity)) {
                        yield 3;
                    }
                    yield 2;
                }
                default -> 0;
            };
        }
        return switch (instance.getMode()) {
            case 3 -> {
                if (instance.getOrCreateTag().m_128451_("HellFlare") >= 200) {
                    yield 4;
                }
                yield 1;
            }
            case 2 -> {
                if (this.canEquipHellFlare(entity)) {
                    yield 3;
                }
                yield 1;
            }
            case 1 -> 2;
            default -> 1;
        };
    }

    @Override
    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"tensura.skill.mode.black_flame.breath");
            case 2 -> Component.m_237115_((String)"tensura.skill.mode.black_flame.ball");
            case 3 -> Component.m_237115_((String)"tensura.skill.mode.black_flame.hell_flare");
            case 4 -> Component.m_237115_((String)"tensura.skill.mode.black_flame.limited_hell_flare");
            default -> Component.m_237119_();
        };
    }

    private boolean canEquipHellFlare(LivingEntity entity) {
        if (!SkillUtils.hasSkill((Entity)entity, (ManasSkill)CommonSkills.RANGED_BARRIER.get())) {
            return false;
        }
        return SkillUtils.hasSkill((Entity)entity, (ManasSkill)ExtraSkills.FLAME_MANIPULATION.get()) || SkillUtils.hasSkill((Entity)entity, (ManasSkill)ExtraSkills.FLAME_DOMINATION.get());
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 2 -> 100.0;
            case 1 -> 50.0;
            default -> 0.0;
        };
    }

    @Override
    public String modeLearningId(int mode) {
        if (mode == 3) {
            return "HellFlare";
        }
        return "None";
    }

    public boolean canIgnoreCoolDown(ManasSkillInstance instance, LivingEntity entity) {
        if (instance.getMastery() < 0) {
            return false;
        }
        CompoundTag tag = instance.getOrCreateTag();
        return instance.getMode() != 3 && tag.m_128451_("HellFlare") <= 100;
    }

    public void onTouchEntity(ManasSkillInstance instance, LivingEntity attacker, LivingHurtEvent e) {
        int level;
        if (!instance.isToggled()) {
            return;
        }
        if (SkillHelper.outOfMagicule(attacker, 5.0)) {
            return;
        }
        if (!DamageSourceHelper.isPhysicalAttack(e.getSource()) && !(e.getSource().m_7639_() instanceof AbstractArrow)) {
            return;
        }
        LivingEntity target = e.getEntity();
        int n = level = this.isMastered(instance, attacker) ? 1 : 0;
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            SkillHelper.addEffectWithSource(target, (LivingEntity)player, (MobEffect)TensuraMobEffects.BLACK_BURN.get(), 200, level);
        } else {
            target.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.BLACK_BURN.get(), 200, level, false, false, false));
        }
        attacker.m_9236_().m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), SoundEvents.f_11909_, SoundSource.PLAYERS, 1.0f, 1.0f);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)TensuraParticles.BLACK_FIRE.get(), 1.0);
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (instance.getMode() != 1) {
            return false;
        }
        if (heldTicks % 20 == 0 && SkillHelper.outOfMagicule(entity, instance)) {
            return false;
        }
        if (heldTicks % 100 == 0 && heldTicks > 0) {
            this.addMasteryPoint(instance, entity);
        }
        float damage = instance.isMastered(entity) ? 20.0f : 10.0f;
        BreathEntity.spawnBreathEntity((EntityType<? extends BreathEntity>)((EntityType)TensuraEntityTypes.BLACK_FLAME_BREATH.get()), entity, instance, damage, this.magiculeCost(entity, instance));
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11705_, SoundSource.PLAYERS, 1.0f, 1.0f);
        return true;
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        Level level = entity.m_9236_();
        CompoundTag tag = instance.getOrCreateTag();
        switch (instance.getMode()) {
            case 1: {
                instance.getOrCreateTag().m_128405_("BreathEntity", 0);
                instance.markDirty();
                break;
            }
            case 2: {
                if (SkillHelper.outOfMagicule(entity, instance)) {
                    return;
                }
                this.addMasteryPoint(instance, entity);
                BlackFlameBallProjectile ball = new BlackFlameBallProjectile(entity.m_9236_(), entity);
                ball.setDamage(50.0f);
                ball.setSpeed(1.5f);
                ball.setExplosionRadius(1.0f);
                ball.setMpCost(this.magiculeCost(entity, instance));
                ball.setSkill(instance);
                ball.setPosAndShoot(entity);
                level.m_7967_((Entity)ball);
                level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11705_, SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
            case 3: {
                if (SkillHelper.outOfMagicule(entity, instance)) {
                    return;
                }
                int learnPoint = tag.m_128451_("HellFlare");
                if (learnPoint < 100) {
                    tag.m_128405_("HellFlare", learnPoint + SkillUtils.getEarningLearnPoint(instance, entity, true));
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        if (tag.m_128451_("HellFlare") >= 100) {
                            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire_learning", (Object[])new Object[]{this.getModeName(3)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                        } else {
                            instance.setCoolDown(10);
                            SkillUtils.learningFailPenalty(entity);
                            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.learn_points_added", (Object[])new Object[]{this.getModeName(3)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), true);
                        }
                        player.m_6330_(SoundEvents.f_11871_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                    instance.markDirty();
                    return;
                }
                instance.setCoolDown(1);
                int masteryPoint = tag.m_128451_("HellFlare");
                if (masteryPoint < 200) {
                    tag.m_128405_("HellFlare", masteryPoint + SkillUtils.getBonusMasteryPoint(instance, entity, 1));
                    if (tag.m_128451_("HellFlare") >= 200 && entity instanceof Player) {
                        Player player = (Player)entity;
                        player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.mastery", (Object[])new Object[]{this.getModeName(4)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                    }
                    instance.markDirty();
                }
                HellFlareProjectile projectile = new HellFlareProjectile(entity.m_9236_(), (Entity)entity);
                projectile.setDamage(750.0f);
                projectile.setSpeed(1.5f);
                projectile.setAreaLife(60);
                projectile.setAreaRadius(15.0f);
                projectile.setSkill(instance);
                projectile.setMpCost(this.magiculeCost(entity, instance));
                projectile.setPosAndShoot(entity);
                entity.m_9236_().m_7967_((Entity)projectile);
                entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11705_, SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
            case 4: {
                if (SkillHelper.outOfMagicule(entity, instance)) {
                    return;
                }
                instance.setCoolDown(2);
                HellFlareProjectile projectile = new HellFlareProjectile(entity.m_9236_(), (Entity)entity);
                projectile.setDamage(2500.0f);
                projectile.setSpeed(1.5f);
                projectile.setAreaLife(60);
                projectile.setAreaRadius(2.5f);
                projectile.setSkill(instance);
                projectile.setMpCost(this.magiculeCost(entity, instance));
                projectile.setPosAndShoot(entity);
                entity.m_9236_().m_7967_((Entity)projectile);
                entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11705_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }
}

