/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.common;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.common.TelepathySkill;
import com.github.manasmods.tensura.entity.template.TensuraHorseEntity;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;

public class ThoughtCommunicationSkill
extends Skill {
    public ThoughtCommunicationSkill() {
        super(Skill.SkillType.COMMON);
    }

    @Override
    protected boolean canActivateInRaceLimit(ManasSkillInstance instance) {
        return true;
    }

    @Override
    public int modes() {
        return 2;
    }

    @Override
    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (instance.isMastered(entity)) {
            return instance.getMode() == 1 ? 2 : 1;
        }
        return instance.getMode() == 1 ? 0 : 1;
    }

    @Override
    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"tensura.skill.mode.thought_communication.movement");
            case 2 -> Component.m_237115_((String)"tensura.skill.mode.thought_communication.targeting");
            default -> Component.m_237119_();
        };
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        if (instance.getMode() == 1) {
            ThoughtCommunicationSkill.movementBehaviour(instance, entity);
        } else {
            ThoughtCommunicationSkill.targetingBehaviour(instance, entity);
        }
    }

    public static void movementBehaviour(ManasSkillInstance instance, LivingEntity entity) {
        CompoundTag tag = instance.getOrCreateTag();
        if (entity.m_6144_()) {
            List list = entity.m_9236_().m_6443_(Mob.class, entity.m_20191_().m_82400_(15.0), living -> living.m_7307_((Entity)entity) && !living.m_7306_((Entity)entity));
            if (list.isEmpty()) {
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.m_5661_((Component)Component.m_237115_((String)"tensura.telepathy.subordinate_all.not_found").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.AQUA)), true);
                }
                return;
            }
            if (tag.m_128451_("usedTimes") % 10 == 0) {
                instance.addMasteryPoint(entity);
            }
            tag.m_128405_("usedTimes", tag.m_128451_("usedTimes") + 1);
            int command = tag.m_128451_("command");
            command = command == 3 ? 1 : command + 1;
            tag.m_128405_("command", command);
            instance.markDirty();
            for (Mob mob : list) {
                MutableComponent message = switch (command) {
                    default -> {
                        SkillHelper.setStay((LivingEntity)mob);
                        yield Component.m_237115_((String)"tensura.telepathy.subordinate_all.stay");
                    }
                    case 2 -> {
                        SkillHelper.setFollow((LivingEntity)mob);
                        yield Component.m_237115_((String)"tensura.telepathy.subordinate_all.follow");
                    }
                    case 3 -> {
                        SkillHelper.setWander((LivingEntity)mob);
                        yield Component.m_237115_((String)"tensura.telepathy.subordinate_all.wander");
                    }
                };
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.m_5661_((Component)message.m_6270_(Style.f_131099_.m_131140_(ChatFormatting.AQUA)), true);
                }
                entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        } else {
            ThoughtCommunicationSkill.movementTelepathy(instance, entity);
        }
    }

    public static void movementTelepathy(ManasSkillInstance instance, LivingEntity entity) {
        CompoundTag tag = instance.getOrCreateTag();
        LivingEntity target = SkillHelper.getTargetingEntity(entity, 30.0, false, false);
        if (target == null) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_5661_((Component)Component.m_237115_((String)"tensura.targeting.not_targeted").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.AQUA)), true);
            }
            return;
        }
        if (SkillHelper.isSubordinate(entity, target) && target instanceof Mob) {
            Mob mob = (Mob)target;
            TelepathySkill.telepathy(instance, entity, mob);
        } else if (ThoughtCommunicationSkill.attackCommand((Entity)entity, entity, target, 30.0)) {
            if (tag.m_128451_("usedTimes") % 10 == 0) {
                instance.addMasteryPoint(entity);
            }
            tag.m_128405_("usedTimes", tag.m_128451_("usedTimes") + 1);
            instance.markDirty();
        }
    }

    public static boolean attackCommand(Entity directCommander, LivingEntity owner, LivingEntity target, double radius) {
        Player pPlayer;
        if (target instanceof Player && ((pPlayer = (Player)target).m_7500_() || pPlayer.m_5833_())) {
            return false;
        }
        List list = directCommander.m_9236_().m_6443_(Mob.class, directCommander.m_20191_().m_82400_(radius), mob -> SkillHelper.isSubordinate(owner, (LivingEntity)mob));
        if (list.isEmpty()) {
            if (directCommander == owner && owner instanceof Player) {
                Player player = (Player)owner;
                player.m_5661_((Component)Component.m_237115_((String)"tensura.telepathy.subordinate_all.not_found").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.AQUA)), true);
            }
            return false;
        }
        for (Mob mob2 : list) {
            mob2.m_6710_(target);
            SkillHelper.setFollow((LivingEntity)mob2);
        }
        if (directCommander == owner) {
            owner.m_21011_(InteractionHand.MAIN_HAND, true);
        }
        directCommander.m_9236_().m_6263_(null, directCommander.m_20185_(), directCommander.m_20186_(), directCommander.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
        return true;
    }

    public static void targetingBehaviour(ManasSkillInstance instance, LivingEntity entity) {
        CompoundTag tag = instance.getOrCreateTag();
        if (entity.m_6144_()) {
            List list = entity.m_9236_().m_6443_(Mob.class, entity.m_20191_().m_82400_(15.0), living -> living.m_7307_((Entity)entity) && !living.m_7306_((Entity)entity));
            if (list.isEmpty()) {
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.m_5661_((Component)Component.m_237115_((String)"tensura.telepathy.subordinate_all.not_found").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.AQUA)), true);
                }
                return;
            }
            int command = tag.m_128451_("targetingCommand");
            command = command == 3 ? 0 : command + 1;
            tag.m_128405_("targetingCommand", command);
            instance.markDirty();
            for (Mob mob : list) {
                MutableComponent message = switch (command) {
                    default -> {
                        SkillHelper.setPassive((LivingEntity)mob);
                        yield Component.m_237115_((String)"tensura.telepathy.subordinate_all.passive");
                    }
                    case 1 -> {
                        SkillHelper.setAggressive((LivingEntity)mob);
                        yield Component.m_237115_((String)"tensura.telepathy.subordinate_all.aggressive");
                    }
                    case 2 -> {
                        SkillHelper.setProtect((LivingEntity)mob);
                        yield Component.m_237115_((String)"tensura.telepathy.subordinate_all.protect");
                    }
                    case 3 -> {
                        SkillHelper.setNeutral((LivingEntity)mob);
                        yield Component.m_237115_((String)"tensura.telepathy.subordinate_all.neutral");
                    }
                };
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.m_5661_((Component)message.m_6270_(Style.f_131099_.m_131140_(ChatFormatting.AQUA)), true);
                }
                entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        } else {
            ThoughtCommunicationSkill.targetingTelepathy(entity);
        }
    }

    public static void targetingTelepathy(LivingEntity entity) {
        Mob mob = SkillHelper.getTargetingEntity(Mob.class, entity, 30.0, 0.2, false, false);
        if (mob != null && SkillHelper.isSubordinate(entity, (LivingEntity)mob)) {
            if (mob instanceof TensuraTamableEntity) {
                TensuraTamableEntity tamable = (TensuraTamableEntity)mob;
                tamable.cycleBehaviour(entity);
            } else if (mob instanceof TensuraHorseEntity) {
                TensuraHorseEntity horse = (TensuraHorseEntity)mob;
                horse.cycleBehaviour(entity);
            }
            entity.m_21011_(InteractionHand.MAIN_HAND, true);
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
        } else if (entity instanceof Player) {
            Player player = (Player)entity;
            player.m_5661_((Component)Component.m_237115_((String)"tensura.telepathy.subordinate.not_found").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
        }
    }
}

