/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.common;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.entity.magic.barrier.BarrierEntity;
import com.github.manasmods.tensura.entity.magic.barrier.BarrierPart;
import com.github.manasmods.tensura.entity.magic.barrier.RangedBarrierEntity;
import com.github.manasmods.tensura.registry.TensuraStats;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.StatType;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class RangedBarrierSkill
extends Skill {
    public RangedBarrierSkill() {
        super(Skill.SkillType.COMMON);
    }

    @Override
    public double learningCost() {
        return 100.0;
    }

    @Override
    public boolean meetEPRequirement(Player entity, double newEP) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (player.m_8951_().m_13015_(((StatType)TensuraStats.BOSS_KILLED.get()).m_12902_((Object)((EntityType)TensuraEntityTypes.IFRIT.get()))) <= 0) {
                return false;
            }
            return TensuraEPCapability.getEP((LivingEntity)entity) >= 80000.0;
        }
        return false;
    }

    @Override
    public int modes() {
        return 3;
    }

    @Override
    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return switch (instance.getMode()) {
                case 3 -> 2;
                case 2 -> 1;
                case 1 -> {
                    if (this.isMastered(instance, entity)) {
                        yield 3;
                    }
                    yield 2;
                }
                default -> 0;
            };
        }
        return switch (instance.getMode()) {
            case 2 -> {
                if (this.isMastered(instance, entity)) {
                    yield 3;
                }
                yield 1;
            }
            case 1 -> 2;
            default -> 1;
        };
    }

    @Override
    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"tensura.skill.mode.ranged_barrier.5");
            case 2 -> Component.m_237115_((String)"tensura.skill.mode.ranged_barrier.10");
            case 3 -> Component.m_237115_((String)"tensura.skill.mode.ranged_barrier.20");
            default -> Component.m_237119_();
        };
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 5 * this.getRadiusMode(instance.getMode());
    }

    public void onSkillMastered(ManasSkillInstance instance, LivingEntity entity) {
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        ManasSkill skill = (ManasSkill)ExtraSkills.MULTILAYER_BARRIER.get();
        TensuraSkillInstance manipulation = new TensuraSkillInstance(skill);
        manipulation.setMastery(-100);
        if (storage.learnSkill((ManasSkillInstance)manipulation) && entity instanceof Player) {
            Player player = (Player)entity;
            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.learn_available", (Object[])new Object[]{skill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN)), false);
        }
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        Vec3 pos;
        Level level = entity.m_9236_();
        Class targetClass = entity.m_6144_() ? BarrierPart.class : LivingEntity.class;
        BarrierPart target = SkillHelper.getTargetingEntity(targetClass, entity, 30.0, 0.1, false, false);
        if (target != null) {
            pos = target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() / 2.0f), 0.0);
            if (entity.m_6144_() && target instanceof BarrierPart) {
                RangedBarrierEntity barrier;
                BarrierPart part = target;
                BarrierEntity barrierEntity = part.barrier;
                if (barrierEntity instanceof RangedBarrierEntity && (barrier = (RangedBarrierEntity)barrierEntity).m_37282_() == entity) {
                    barrier.m_146870_();
                    level.m_6263_(null, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    return;
                }
            }
        } else {
            BlockHitResult result = SkillHelper.getPlayerPOVHitResult(level, (Entity)entity, ClipContext.Fluid.NONE, ClipContext.Block.OUTLINE, 30.0);
            pos = result.m_82450_().m_82520_(0.0, 0.5, 0.0);
        }
        if (SkillHelper.outOfMagicule(entity, instance)) {
            return;
        }
        RangedBarrierEntity sphere = new RangedBarrierEntity(entity.m_9236_(), entity);
        sphere.m_146884_(pos);
        sphere.setMpCost(this.magiculeCost(entity, instance));
        sphere.setSkill(instance);
        sphere.setHealth(entity.m_21233_() / 2.0f);
        sphere.setLife(instance.isMastered(entity) ? 2400 : 1200);
        sphere.setRadius(this.getRadiusMode(instance.getMode()));
        entity.m_9236_().m_7967_((Entity)sphere);
        if (target != null) {
            this.addMasteryPoint(instance, entity);
        }
        instance.setCoolDown(instance.getMode());
        entity.m_21011_(InteractionHand.MAIN_HAND, true);
        level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11868_, SoundSource.PLAYERS, 0.5f, 1.0f);
    }

    public int getRadiusMode(int mode) {
        return switch (mode) {
            case 1 -> 2;
            case 2 -> 5;
            case 3 -> 10;
            default -> 0;
        };
    }
}

