/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.skill.common;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import com.github.manasmods.tensura.registry.skill.CommonSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class HydraulicPropulsionSkill
extends Skill {
    public HydraulicPropulsionSkill() {
        super(Skill.SkillType.COMMON);
    }

    @Override
    public double learningCost() {
        return 2.0;
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 2.0;
    }

    public void onSkillMastered(ManasSkillInstance instance, LivingEntity entity) {
        if (TensuraEPCapability.getEP(entity) < 10000.0) {
            return;
        }
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        ManasSkill skill = (ManasSkill)CommonSkills.WATER_BLADE.get();
        TensuraSkillInstance manipulation = new TensuraSkillInstance(skill);
        manipulation.setMastery(-100);
        if (storage.learnSkill((ManasSkillInstance)manipulation) && entity instanceof Player) {
            Player player = (Player)entity;
            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.learn_available", (Object[])new Object[]{skill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN)), false);
        }
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        if (!entity.m_20072_()) {
            return;
        }
        if (entity.m_21209_()) {
            return;
        }
        if (SkillHelper.outOfMagicule(entity, instance)) {
            return;
        }
        this.addMasteryPoint(instance, entity);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.m_204079_(10);
        }
        SkillHelper.riptidePush(entity, 2.0f);
        entity.f_19864_ = true;
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12519_, SoundSource.PLAYERS, 1.0f, 1.0f);
        TensuraParticleHelper.spawnServerParticles(entity.f_19853_, (ParticleOptions)TensuraParticles.WATER_EFFECT.get(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 55, 0.08, 0.08, 0.08, 0.15, true);
        TensuraParticleHelper.spawnServerParticles(entity.f_19853_, (ParticleOptions)TensuraParticles.WATER_EFFECT.get(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 25, 0.08, 0.08, 0.08, 0.15, false);
    }

    public static void riptideImpact(LivingEntity entity, LivingEntity target) {
        Level level = entity.m_9236_();
        level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12278_, SoundSource.PLAYERS, 1.0f, 1.0f);
        target.f_19802_ = 0;
        target.m_6469_((DamageSource)DamageSourceHelper.addSkillAndCost(DamageSource.m_19370_((LivingEntity)entity), 2.0, SkillUtils.getSkillOrNull((Entity)entity, (ManasSkill)CommonSkills.HYDRAULIC_PROPULSION.get())), 4.0f);
        if (target.m_6060_()) {
            target.m_20095_();
        }
        double d0 = Math.max(0.0, 1.0 - target.m_21133_(Attributes.f_22278_));
        Vec3 vec3 = entity.m_20252_(1.0f).m_82541_().m_82490_(2.0 * d0 * (double)0.1f);
        if (vec3.m_82556_() > 0.0) {
            target.m_5997_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
        }
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        ((ServerLevel)level).m_8767_((ParticleOptions)((SimpleParticleType)TensuraParticles.WATER_BUBBLE.get()), target.m_20182_().f_82479_, target.m_20182_().f_82480_ + (double)target.m_20206_() / 2.0, target.m_20182_().f_82481_, 20, 0.08, 0.08, 0.08, 0.15);
    }
}

