/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.magic.summon;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.magic.summon.SummoningMagic;
import com.github.manasmods.tensura.entity.HoundDogEntity;
import com.github.manasmods.tensura.entity.variant.HoundDogVariant;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class SummonHoundDogMagic
extends SummoningMagic<HoundDogEntity> {
    @Override
    public int defaultCast() {
        return 100;
    }

    @Override
    public int masteryCast() {
        return 60;
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 50.0;
    }

    @Override
    protected int getSuccessCooldown(ManasSkillInstance instance, LivingEntity entity) {
        if (instance.isMastered(entity)) {
            return 3600;
        }
        return 6000;
    }

    @Override
    protected void removeExistingSummon(ManasSkillInstance instance, LivingEntity entity) {
        HoundDogEntity dog = SkillHelper.getTargetingEntity(HoundDogEntity.class, entity, 30.0, 0.2, false);
        if (dog == null) {
            return;
        }
        if (!dog.m_21830_(entity)) {
            return;
        }
        if (dog.getSummoningTick() < 0) {
            return;
        }
        dog.m_6469_(TensuraDamageSources.noEnergySource((Entity)entity), dog.m_21233_());
        instance.setCoolDown(0);
    }

    @Override
    protected void addAdditionalSummonData(ManasSkillInstance instance, LivingEntity entity, HoundDogEntity summon) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            summon.m_21828_(player);
        }
        summon.setSummoningTick(6000);
        summon.setVariant(HoundDogVariant.EVOLVED);
        summon.m_217045_();
    }

    @Override
    protected EntityType<? extends HoundDogEntity> getSummonedType(ManasSkillInstance instance) {
        return (EntityType)TensuraEntityTypes.HOUND_DOG.get();
    }

    @Override
    protected ResourceLocation getSummoningFxLocation(ManasSkillInstance instance) {
        return new ResourceLocation("tensura:dark_circle");
    }

    @Override
    protected ParticleOptions getSummoningParticle(ManasSkillInstance instance) {
        return ParticleTypes.f_123784_;
    }

    @Override
    protected SoundEvent getSummoningSound(ManasSkillInstance instance) {
        return SoundEvents.f_12049_;
    }

    @Override
    protected SoundEvent getFailSound(ManasSkillInstance instance) {
        return SoundEvents.f_12618_;
    }
}

