/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.magic.summon;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.event.UnlockSkillEvent;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.ability.magic.spiritual.SpiritualMagic;
import com.github.manasmods.tensura.ability.magic.summon.SummoningMagic;
import com.github.manasmods.tensura.api.entity.subclass.IElementalSpirit;
import com.github.manasmods.tensura.api.entity.subclass.ISummonable;
import com.github.manasmods.tensura.capability.skill.TensuraSkillCapability;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import java.util.List;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;

public abstract class SummonElementalMagic
extends SummoningMagic<TamableAnimal> {
    private final SpiritualMagic.SpiritLevel level;

    public SummonElementalMagic(SpiritualMagic.SpiritLevel level) {
        this.level = level;
    }

    @Override
    public int defaultCast() {
        return 100;
    }

    @Override
    public int masteryCast() {
        return 60;
    }

    public void onLearnSkill(ManasSkillInstance instance, LivingEntity living, UnlockSkillEvent event) {
        instance.setMode(0);
    }

    @Override
    public int modes() {
        return 5;
    }

    @Override
    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (!(entity instanceof Player)) {
            return 0;
        }
        Player player = (Player)entity;
        int currentSpirit = instance.getMode() - 1;
        int nextMode = 0;
        for (int tries = 0; nextMode == 0 && tries <= 5; ++tries) {
            if (reverse) {
                currentSpirit = currentSpirit - 1 == -1 ? 4 : currentSpirit - 1;
            } else {
                int n = currentSpirit = currentSpirit + 1 == 5 ? 0 : currentSpirit + 1;
            }
            if (!this.containsSpirit(instance, player, currentSpirit)) continue;
            nextMode = currentSpirit + 1;
        }
        return nextMode;
    }

    private boolean containsSpirit(TensuraSkillInstance instance, Player player, int spirit) {
        int level = this.getLevel().getId();
        List<MagicElemental> elementals = MagicElemental.getCommonElementals();
        if (TensuraSkillCapability.getSpiritLevel(player, elementals.get(spirit).getId()) >= level) {
            return true;
        }
        CompoundTag tag = instance.getTag();
        if (tag == null) {
            return false;
        }
        if (!tag.m_128441_("SpiritTamed")) {
            return false;
        }
        return tag.m_128469_("SpiritTamed").m_128451_(MagicElemental.getCommonElementals().get(spirit).getNamespace()) >= level;
    }

    public static void addSpiritSummonLevel(ManasSkillInstance instance, IElementalSpirit spirit) {
        CompoundTag tag = instance.getOrCreateTag();
        if (tag.m_128441_("SpiritTamed")) {
            CompoundTag spiritTamed = tag.m_128469_("SpiritTamed");
            int currentLevel = spiritTamed.m_128451_(spirit.getElemental().getNamespace());
            if (currentLevel >= spirit.getSpiritLevel().getId()) {
                return;
            }
            spiritTamed.m_128405_(spirit.getElemental().getNamespace(), spirit.getSpiritLevel().getId());
            instance.markDirty();
        } else {
            CompoundTag spiritTamed = new CompoundTag();
            spiritTamed.m_128405_(spirit.getElemental().getNamespace(), spirit.getSpiritLevel().getId());
            tag.m_128365_("SpiritTamed", (Tag)spiritTamed);
            instance.markDirty();
        }
    }

    @Override
    protected int getSuccessCooldown(ManasSkillInstance instance, LivingEntity entity) {
        if (instance.isMastered(entity)) {
            return 3600;
        }
        return 6000;
    }

    @Override
    protected void removeExistingSummon(ManasSkillInstance instance, LivingEntity entity) {
        TamableAnimal summon = SkillHelper.getTargetingEntity(TamableAnimal.class, entity, 30.0, 0.2, false);
        if (summon == null) {
            return;
        }
        if (!(summon instanceof IElementalSpirit)) {
            return;
        }
        IElementalSpirit spirit = (IElementalSpirit)summon;
        if (!summon.m_21830_(entity)) {
            return;
        }
        if (spirit.getSummoningTick() < 0) {
            return;
        }
        if (spirit.getSpiritLevel() != this.getLevel()) {
            return;
        }
        summon.m_6469_(TensuraDamageSources.noEnergySource((Entity)entity), summon.m_21233_());
        instance.setCoolDown(0);
    }

    @Override
    protected void addAdditionalSummonData(ManasSkillInstance instance, LivingEntity entity, TamableAnimal summon) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            summon.m_21828_(player);
        }
        if (summon instanceof ISummonable) {
            ISummonable summonable = (ISummonable)summon;
            summonable.setSummoningTick(6000);
        }
        summon.m_217045_();
    }

    @Override
    protected ResourceLocation getSummoningFxLocation(ManasSkillInstance instance) {
        String name = MagicElemental.getCommonElementals().get(instance.getMode() - 1).getNamespace();
        return new ResourceLocation("tensura:" + name + "_circle");
    }

    @Override
    protected ParticleOptions getSummoningParticle(ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            default -> (SimpleParticleType)TensuraParticles.RED_FIRE.get();
            case 1 -> new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_152537_.m_49966_());
            case 3 -> ParticleTypes.f_123789_;
            case 4 -> (SimpleParticleType)TensuraParticles.WATER_BUBBLE.get();
            case 5 -> (SimpleParticleType)TensuraParticles.SMALL_GUST.get();
        };
    }

    @Override
    protected SoundEvent getSummoningSound(ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            default -> SoundEvents.f_11705_;
            case 1 -> SoundEvents.f_144135_;
            case 3 -> SoundEvents.f_11852_;
            case 4 -> SoundEvents.f_12324_;
            case 5 -> SoundEvents.f_12317_;
        };
    }

    @Override
    protected SoundEvent getFailSound(ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            default -> SoundEvents.f_11703_;
            case 1 -> SoundEvents.f_12059_;
            case 3 -> SoundEvents.f_11787_;
            case 4 -> SoundEvents.f_215691_;
        };
    }

    public SpiritualMagic.SpiritLevel getLevel() {
        return this.level;
    }
}

