/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.magic.spiritual.wind;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.ability.magic.spiritual.SpiritualMagic;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class WindMagic
extends SpiritualMagic {
    public WindMagic() {
        super(MagicElemental.WIND, SpiritualMagic.SpiritLevel.LESSER);
    }

    @Override
    public boolean isInstant(ManasSkillInstance instance, LivingEntity entity) {
        return instance.isMastered(entity);
    }

    @Override
    public int defaultCast() {
        return 20;
    }

    @Override
    public int masteryCast() {
        return 1;
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 25.0;
    }

    public void onRelease(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        super.onRelease(instance, entity, heldTicks);
        if (this.getHeldTicks(instance) < this.castingTime(instance, entity)) {
            return;
        }
        if (SkillHelper.outOfMagicule(entity, instance)) {
            return;
        }
        entity.m_21011_(InteractionHand.MAIN_HAND, true);
        this.addMasteryPoint(instance, entity);
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)TensuraParticles.GUST.get(), 2.0);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)TensuraParticles.SMALL_GUST.get(), 2.0);
        List list = entity.m_9236_().m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(3.0), living -> !living.m_7306_((Entity)entity) && living.m_6084_());
        if (!list.isEmpty()) {
            for (LivingEntity target : list) {
                if (target instanceof Player) {
                    Player player = (Player)target;
                    if (player.m_150110_().f_35934_) continue;
                }
                SkillHelper.knockBack(entity, target, 1.5f);
            }
        }
        entity.m_183634_();
        Vec3 delta = entity.m_20184_();
        double dy = delta.f_82480_ <= 0.0 ? 1.0 : delta.f_82480_ + 1.0;
        entity.m_20256_(new Vec3(delta.m_7096_(), dy, delta.m_7094_()));
        entity.f_19812_ = true;
        entity.f_19864_ = true;
    }
}

