/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.magic.spiritual.wind;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.ability.magic.spiritual.SpiritualMagic;
import com.github.manasmods.tensura.entity.magic.projectile.LightningLanceProjectile;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class LightningLanceMagic
extends SpiritualMagic {
    public LightningLanceMagic() {
        super(MagicElemental.WIND, SpiritualMagic.SpiritLevel.MEDIUM);
    }

    @Override
    public int defaultCast() {
        return 40;
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 125.0;
    }

    public void onRelease(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        super.onRelease(instance, entity, heldTicks);
        if (this.getHeldTicks(instance) < this.castingTime(instance, entity)) {
            return;
        }
        if (SkillHelper.outOfMagicule(entity, instance)) {
            return;
        }
        entity.m_21011_(InteractionHand.MAIN_HAND, true);
        this.addMasteryPoint(instance, entity);
        LightningLanceProjectile lance = new LightningLanceProjectile(entity.m_9236_(), entity);
        lance.setEffectRange(-1.0f);
        lance.setSpeed(1.75f);
        lance.setDamage(instance.isMastered(entity) ? 40.0f : 30.0f);
        lance.setMpCost(this.magiculeCost(entity, instance));
        lance.setSkill(instance);
        lance.setSpiritAttack(true);
        lance.m_20242_(true);
        lance.setPosAndShoot(entity);
        entity.m_9236_().m_7967_((Entity)lance);
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }
}

