/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.magic.spiritual.water;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.ability.magic.spiritual.SpiritualMagic;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.event.SkillGriefEvent;
import com.github.manasmods.tensura.world.TensuraGameRules;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class WaterMagic
extends SpiritualMagic {
    public WaterMagic() {
        super(MagicElemental.WATER, SpiritualMagic.SpiritLevel.LESSER);
    }

    @Override
    public boolean isInstant(ManasSkillInstance instance, LivingEntity entity) {
        return instance.isMastered(entity);
    }

    @Override
    public int defaultCast() {
        return 20;
    }

    @Override
    public int masteryCast() {
        return 1;
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 50.0;
    }

    public void onRelease(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        super.onRelease(instance, entity, heldTicks);
        if (this.getHeldTicks(instance) < this.castingTime(instance, entity)) {
            return;
        }
        Level level = entity.m_9236_();
        if (WaterMagic.isWaterEvaporated(entity, level)) {
            return;
        }
        if (!TensuraGameRules.canSkillGrief(level)) {
            return;
        }
        this.addMasteryPoint(instance, entity);
        BlockHitResult result = SkillHelper.getPlayerPOVHitResult(level, (Entity)entity, ClipContext.Fluid.NONE, 6.0);
        if (result.m_6662_() != HitResult.Type.ENTITY) {
            if (SkillHelper.outOfMagicule(entity, instance)) {
                return;
            }
            BlockPos pos = result.m_82425_();
            BlockPos relative = pos.m_121945_(result.m_82434_());
            BlockState relativeState = level.m_8055_(relative);
            SkillGriefEvent.Pre preGrief = new SkillGriefEvent.Pre((Entity)entity, instance, relative);
            if (MinecraftForge.EVENT_BUS.post((Event)preGrief)) {
                return;
            }
            if (result.m_6662_() == HitResult.Type.MISS && relativeState.m_60819_().m_192917_((Fluid)Fluids.f_76193_)) {
                level.m_7731_(relative, Blocks.f_50126_.m_49966_(), 11);
                level.m_142346_((Entity)entity, GameEvent.f_157797_, relative);
                this.addMasteryPoint(instance, entity);
            } else if (result.m_6662_() == HitResult.Type.BLOCK) {
                if (level.m_8055_(pos).m_60713_(Blocks.f_50126_)) {
                    level.m_7731_(pos, Blocks.f_49990_.m_49966_(), 11);
                    level.m_142346_((Entity)entity, GameEvent.f_157797_, relative);
                    this.addMasteryPoint(instance, entity);
                } else if (relativeState.m_60819_().m_192917_((Fluid)Fluids.f_76193_)) {
                    level.m_7731_(relative, Blocks.f_50126_.m_49966_(), 11);
                    level.m_142346_((Entity)entity, GameEvent.f_157797_, relative);
                    this.addMasteryPoint(instance, entity);
                } else {
                    level.m_7731_(relative, Blocks.f_49990_.m_49966_(), 11);
                    level.m_142346_((Entity)entity, GameEvent.f_157797_, relative);
                    this.addMasteryPoint(instance, entity);
                }
            }
            MinecraftForge.EVENT_BUS.post((Event)new SkillGriefEvent.Post((Entity)entity, instance, relative));
            entity.m_21011_(InteractionHand.MAIN_HAND, true);
            level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_144205_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
    }

    public static boolean isWaterEvaporated(LivingEntity entity, Level level) {
        if (!level.m_6042_().f_63857_()) {
            return false;
        }
        level.m_5594_(null, entity.m_20097_().m_7494_(), SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (entity.m_217043_().m_188501_() - entity.m_217043_().m_188501_()) * 0.8f);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_123759_);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_123759_, 2.0);
        return true;
    }
}

