/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.magic.spiritual.water;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.ability.magic.spiritual.SpiritualMagic;
import com.github.manasmods.tensura.ability.magic.spiritual.water.WaterMagic;
import com.github.manasmods.tensura.entity.magic.skill.WaterBladeProjectile;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class WaterCutterMagic
extends SpiritualMagic {
    public WaterCutterMagic() {
        super(MagicElemental.WATER, SpiritualMagic.SpiritLevel.MEDIUM);
    }

    @Override
    public int defaultCast() {
        return 30;
    }

    @Override
    public int masteryCast() {
        return 10;
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 50.0;
    }

    public void onRelease(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        super.onRelease(instance, entity, heldTicks);
        if (this.getHeldTicks(instance) < this.castingTime(instance, entity)) {
            return;
        }
        if (SkillHelper.outOfMagicule(entity, instance)) {
            return;
        }
        entity.m_21011_(InteractionHand.MAIN_HAND, true);
        if (WaterMagic.isWaterEvaporated(entity, entity.f_19853_)) {
            return;
        }
        this.addMasteryPoint(instance, entity);
        WaterBladeProjectile blade = new WaterBladeProjectile(entity.m_9236_(), entity);
        blade.setSpeed(2.0f);
        blade.setDamage(30.0f);
        blade.setMpCost(this.magiculeCost(entity, instance));
        blade.setSkill(instance);
        blade.setSpiritAttack(true);
        blade.setPosAndShoot(entity);
        entity.m_9236_().m_7967_((Entity)blade);
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }
}

