/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.magic.spiritual.water;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.ability.magic.spiritual.SpiritualMagic;
import com.github.manasmods.tensura.entity.magic.barrier.BlizzardEntity;
import com.github.manasmods.tensura.entity.magic.projectile.IceLanceProjectile;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class BlizzardMagic
extends SpiritualMagic {
    public BlizzardMagic() {
        super(MagicElemental.WATER, SpiritualMagic.SpiritLevel.GREATER);
    }

    @Override
    public int defaultCast() {
        return 160;
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 10000.0;
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        if (!this.hasBlizzard(entity)) {
            return;
        }
        if (entity.m_6144_()) {
            for (BlizzardEntity blizzard2 : entity.m_9236_().m_6443_(BlizzardEntity.class, entity.m_20191_(), blizzard -> blizzard.m_37282_() == entity)) {
                blizzard2.m_146870_();
            }
            return;
        }
        if (SkillHelper.outOfMagicule(entity, 2000.0)) {
            return;
        }
        entity.m_21011_(InteractionHand.MAIN_HAND, true);
        this.addMasteryPoint(instance, entity);
        instance.setCoolDown(10);
        IceLanceProjectile iceLance = new IceLanceProjectile(entity.m_9236_(), entity);
        iceLance.setSize(3.0f);
        iceLance.setSpeed(2.0f);
        iceLance.setDamage(250.0f);
        iceLance.setMpCost(this.magiculeCost(entity, instance));
        iceLance.setSkill(instance);
        iceLance.setSpiritAttack(true);
        iceLance.setPosAndShoot(entity);
        entity.m_9236_().m_7967_((Entity)iceLance);
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12049_, SoundSource.PLAYERS, 1.0f, 1.0f);
        instance.getOrCreateTag().m_128405_("HeldTicks", 0);
        instance.markDirty();
    }

    @Override
    public void addHeldAttributeModifiers(ManasSkillInstance instance, LivingEntity entity) {
        if (this.hasBlizzard(entity)) {
            return;
        }
        super.addHeldAttributeModifiers(instance, entity);
    }

    @Override
    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (this.hasBlizzard(entity)) {
            return false;
        }
        return super.onHeld(instance, entity, heldTicks);
    }

    public void onRelease(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        super.onRelease(instance, entity, heldTicks);
        if (entity.m_6144_()) {
            return;
        }
        if (this.hasBlizzard(entity)) {
            return;
        }
        if (this.getHeldTicks(instance) < this.castingTime(instance, entity)) {
            return;
        }
        if (SkillHelper.outOfMagicule(entity, instance)) {
            return;
        }
        entity.m_21011_(InteractionHand.MAIN_HAND, true);
        this.addMasteryPoint(instance, entity);
        BlizzardEntity blizzard = new BlizzardEntity(entity.m_9236_(), entity);
        blizzard.setLife(instance.isMastered(entity) ? 3200 : 2000);
        blizzard.setRadius(15.0f);
        blizzard.setDamage(30.0f);
        blizzard.setMpCost(this.magiculeCost(entity, instance));
        blizzard.setSkill(instance);
        blizzard.m_6034_(entity.m_20185_(), entity.m_20186_() + (double)(entity.m_20206_() / 2.0f), entity.m_20189_());
        entity.m_9236_().m_7967_((Entity)blizzard);
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12090_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    private boolean hasBlizzard(LivingEntity owner) {
        return !owner.m_9236_().m_6443_(BlizzardEntity.class, owner.m_20191_(), blizzard -> blizzard.m_37282_() == owner).isEmpty();
    }
}

