/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.magic.spiritual.light;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.ability.magic.spiritual.SpiritualMagic;
import com.github.manasmods.tensura.entity.projectile.LightArrowProjectile;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class SolarRainMagic
extends SpiritualMagic {
    public SolarRainMagic() {
        super(MagicElemental.LIGHT, SpiritualMagic.SpiritLevel.GREATER);
    }

    @Override
    public int defaultCast() {
        return 80;
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 8000.0;
    }

    public void onRelease(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        Vec3 pos;
        super.onRelease(instance, entity, heldTicks);
        if (this.getHeldTicks(instance) < this.castingTime(instance, entity)) {
            return;
        }
        if (SkillHelper.outOfMagicule(entity, instance)) {
            return;
        }
        entity.m_21011_(InteractionHand.MAIN_HAND, true);
        this.addMasteryPoint(instance, entity);
        Level level = entity.m_9236_();
        int distance = instance.isMastered(entity) ? 30 : 20;
        LivingEntity target = SkillHelper.getTargetingEntity(entity, distance, false, true);
        if (target != null) {
            pos = target.m_146892_();
        } else {
            BlockHitResult result = SkillHelper.getPlayerPOVHitResult(entity.f_19853_, (Entity)entity, ClipContext.Fluid.NONE, distance);
            pos = result.m_82450_().m_82520_(0.0, 0.5, 0.0);
        }
        if (instance.isMastered(entity)) {
            this.spawnLightArrows(instance, entity, pos, 10, 2.0);
            this.spawnLightArrows(instance, entity, pos, 10, 4.0);
        } else {
            this.spawnLightArrows(instance, entity, pos, 10, 3.0);
        }
        level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12049_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    private void spawnLightArrows(ManasSkillInstance instance, LivingEntity entity, Vec3 pos, int arrowAmount, double distance) {
        int arrowRot = 360 / arrowAmount;
        for (int i = 0; i < arrowAmount; ++i) {
            Vec3 arrowPos = entity.m_146892_().m_82549_(new Vec3(0.0, distance, 0.0).m_82535_(((float)(arrowRot * i) - (float)arrowRot / 2.0f) * ((float)Math.PI / 180)).m_82496_(-entity.m_146909_() * ((float)Math.PI / 180)).m_82524_(-entity.m_146908_() * ((float)Math.PI / 180)));
            LightArrowProjectile arrow = new LightArrowProjectile(entity.m_9236_(), entity);
            arrow.setSpeed(2.0f);
            arrow.m_146884_(arrowPos);
            arrow.shootFromRot(pos.m_82546_(arrowPos).m_82541_());
            arrow.setLife(50);
            arrow.setDamage(30.0f);
            arrow.setMpCost(this.magiculeCost(entity, instance) / (double)arrowAmount);
            arrow.setSpiritAttack(true);
            arrow.setSkill(instance);
            entity.m_9236_().m_7967_((Entity)arrow);
        }
    }
}

