/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.magic.spiritual.fire;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.ability.magic.spiritual.SpiritualMagic;
import com.github.manasmods.tensura.entity.magic.breath.BreathEntity;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class FireBreathMagic
extends SpiritualMagic {
    public FireBreathMagic() {
        super(MagicElemental.FLAME, SpiritualMagic.SpiritLevel.MEDIUM);
    }

    @Override
    public int defaultCast() {
        return 10;
    }

    @Override
    public int masteryCast() {
        return 1;
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 50.0;
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        instance.getOrCreateTag().m_128405_("BreathEntity", 0);
        instance.markDirty();
    }

    @Override
    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        int castTime;
        if (heldTicks == 0 && this.alreadyCasting(entity)) {
            return false;
        }
        if (heldTicks % 10 == 0 && SkillHelper.outOfMagicule(entity, instance)) {
            return false;
        }
        if (heldTicks % 60 == 0 && heldTicks > 0) {
            this.addMasteryPoint(instance, entity);
        }
        if (heldTicks >= (castTime = this.castingTime(instance, entity))) {
            float damage = instance.isMastered(entity) ? 14.0f : 7.0f;
            BreathEntity.spawnBreathEntity((EntityType<? extends BreathEntity>)((EntityType)TensuraEntityTypes.FLAME_BREATH.get()), entity, instance, damage, this.magiculeCost(entity, instance));
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11705_, SoundSource.PLAYERS, 1.0f, 1.0f);
        } else if (entity instanceof Player) {
            Player player = (Player)entity;
            this.addCastingParticle(instance, player, heldTicks);
        }
        return true;
    }
}

