/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.magic.spiritual.earth;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.ability.magic.spiritual.SpiritualMagic;
import com.github.manasmods.tensura.entity.magic.spike.EarthSpikeEntity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class EarthSpikesMagic
extends SpiritualMagic {
    public EarthSpikesMagic() {
        super(MagicElemental.EARTH, SpiritualMagic.SpiritLevel.MEDIUM);
    }

    @Override
    public int defaultCast() {
        return 40;
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 150.0;
    }

    public void onRelease(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        Vec3 pos;
        super.onRelease(instance, entity, heldTicks);
        if (this.getHeldTicks(instance) < this.castingTime(instance, entity)) {
            return;
        }
        if (SkillHelper.outOfMagicule(entity, instance)) {
            return;
        }
        Level level = entity.m_9236_();
        LivingEntity targetingEntity = SkillHelper.getTargetingEntity(entity, 20.0, false, true);
        if (targetingEntity != null && targetingEntity.m_20096_()) {
            pos = targetingEntity.m_20182_();
        } else {
            BlockHitResult targetPos = SkillHelper.getPlayerPOVHitResult(entity.f_19853_, (Entity)entity, ClipContext.Fluid.NONE, 20.0);
            pos = targetPos.m_82450_();
            if (!level.m_8055_(new BlockPos(pos).m_7495_()).m_60767_().m_76333_()) {
                pos = null;
            }
        }
        if (pos == null) {
            return;
        }
        instance.addMasteryPoint(entity);
        entity.m_21011_(InteractionHand.MAIN_HAND, true);
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12049_, SoundSource.PLAYERS, 1.0f, 1.0f);
        EarthSpikesMagic.spawnSpikes(pos, entity, instance, 30.0f, this.magiculeCost(entity, instance));
        if (!instance.isMastered(entity)) {
            return;
        }
        List list = entity.m_9236_().m_6443_(LivingEntity.class, new AABB(new BlockPos(pos)).m_82400_(2.5), living -> !living.m_7306_((Entity)entity) && living.m_6084_() && !living.m_7307_((Entity)entity));
        for (LivingEntity target : list) {
            if (!target.m_20096_() || target == targetingEntity) continue;
            EarthSpikesMagic.spawnSpikes(target.m_20182_(), entity, instance, 30.0f, this.magiculeCost(entity, instance));
        }
    }

    public static void spawnSpikes(Vec3 pos, LivingEntity entity, ManasSkillInstance instance, float damage, double cost) {
        EarthSpikeEntity spike = new EarthSpikeEntity(entity.m_9236_(), entity);
        spike.m_146884_(pos);
        spike.setDamage(damage);
        spike.setExtendingTick(5);
        spike.setHeight(4.0f);
        spike.setMpCost(cost);
        spike.setSkill(instance);
        entity.m_9236_().m_7967_((Entity)spike);
    }
}

