/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.magic.spiritual.earth;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.ability.magic.spiritual.SpiritualMagic;
import com.github.manasmods.tensura.event.SkillGriefEvent;
import com.github.manasmods.tensura.world.TensuraGameRules;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class EarthMagic
extends SpiritualMagic {
    public EarthMagic() {
        super(MagicElemental.EARTH, SpiritualMagic.SpiritLevel.LESSER);
    }

    @Override
    public boolean isInstant(ManasSkillInstance instance, LivingEntity entity) {
        return instance.isMastered(entity);
    }

    @Override
    public int defaultCast() {
        return 10;
    }

    @Override
    public int masteryCast() {
        return 1;
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        if (instance.isMastered(entity)) {
            return 20.0;
        }
        return 50.0;
    }

    public void onRelease(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        super.onRelease(instance, entity, heldTicks);
        if (this.getHeldTicks(instance) < this.castingTime(instance, entity)) {
            return;
        }
        Level level = entity.m_9236_();
        if (!TensuraGameRules.canSkillGrief(level)) {
            return;
        }
        this.addMasteryPoint(instance, entity);
        BlockHitResult result = SkillHelper.getPlayerPOVHitResult(level, (Entity)entity, ClipContext.Fluid.NONE, 6.0);
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos pos = result.m_82425_();
            BlockPos relative = pos.m_121945_(result.m_82434_());
            if (level.m_8055_(pos).m_60767_().m_76336_()) {
                relative = pos;
            }
            if (level.m_8055_(relative).m_60767_().m_76336_()) {
                if (SkillHelper.outOfMagicule(entity, instance)) {
                    return;
                }
                SkillGriefEvent.Pre preGrief = new SkillGriefEvent.Pre((Entity)entity, instance, relative);
                if (MinecraftForge.EVENT_BUS.post((Event)preGrief)) {
                    return;
                }
                BlockState earthBlock = this.biomeBlock(level, relative).m_49966_();
                level.m_7731_(relative, earthBlock, 11);
                level.m_142346_((Entity)entity, GameEvent.f_157797_, relative);
                MinecraftForge.EVENT_BUS.post((Event)new SkillGriefEvent.Post((Entity)entity, instance, relative));
                entity.m_21011_(InteractionHand.MAIN_HAND, true);
                entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_144137_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
        }
    }

    private Block biomeBlock(Level level, BlockPos pos) {
        Holder biome = level.m_204166_(pos);
        if (((Biome)biome.get()).toString().contains("desert")) {
            return Blocks.f_49992_;
        }
        if (biome.m_203656_(BiomeTags.f_207604_) || biome.m_203656_(BiomeTags.f_207603_) || biome.m_203656_(BiomeTags.f_207602_)) {
            return Blocks.f_49992_;
        }
        if (((Biome)biome.get()).toString().contains("cave")) {
            return Blocks.f_50069_;
        }
        if (biome.m_203656_(BiomeTags.f_207606_)) {
            return Blocks.f_50069_;
        }
        if (biome.m_203656_(BiomeTags.f_207612_)) {
            return Blocks.f_50134_;
        }
        if (biome.m_203656_(BiomeTags.f_215818_)) {
            return Blocks.f_50259_;
        }
        return Blocks.f_50493_;
    }
}

