/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.magic.spiritual.darkness;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.ability.magic.spiritual.SpiritualMagic;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.entity.magic.barrier.DarkCubeEntity;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class TrueDarknessMagic
extends SpiritualMagic {
    public TrueDarknessMagic() {
        super(MagicElemental.DARKNESS, SpiritualMagic.SpiritLevel.GREATER);
    }

    @Override
    public int defaultCast() {
        return 120;
    }

    @Override
    public double magiculeCost(LivingEntity entity, ManasSkillInstance instance) {
        return 10000.0;
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        instance.getOrCreateTag().m_128405_("BarrierID", 0);
        instance.markDirty();
    }

    @Override
    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        if (heldTicks == 0 && this.alreadyCasting(entity)) {
            return false;
        }
        int castTime = this.castingTime(instance, entity);
        Level level = entity.m_9236_();
        if (heldTicks >= castTime) {
            if (heldTicks == castTime + 1) {
                this.addMasteryPoint(instance, entity);
            }
            DarkCubeEntity.spawnTrueCube((EntityType<? extends DarkCubeEntity>)((EntityType)TensuraEntityTypes.DARK_CUBE.get()), 100.0f, 7.5f, 30, true, entity.m_20182_().m_82520_(0.0, -1.0, 0.0), entity, instance, this.magiculeCost(entity, instance), 1000.0, heldTicks);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)TensuraParticles.DARK_RED_LIGHTNING_SPARK.get());
            level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12049_, SoundSource.PLAYERS, 1.0f, 1.0f);
            return heldTicks - castTime <= (instance.isMastered(entity) ? 400 : 200);
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.addCastingParticle(instance, player, heldTicks);
        }
        return true;
    }
}

