/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.battlewill.projectile;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.battlewill.Battewill;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.entity.magic.projectile.AuraBulletProjectile;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class DarkEightPalmsArt
extends Battewill {
    @Override
    public double learningCost() {
        return 2000.0;
    }

    @Override
    public double auraCost(LivingEntity entity, ManasSkillInstance instance) {
        return 200.0;
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        instance.getOrCreateTag().m_128405_("PowerScale", 0);
        instance.markDirty();
    }

    public boolean onHeld(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        CompoundTag tag = instance.getOrCreateTag();
        int power = tag.m_128451_("PowerScale");
        if (heldTicks > 0 && heldTicks % 2 == 0 && power < 80) {
            tag.m_128405_("PowerScale", power + (instance.isMastered(entity) ? 2 : 1));
            instance.markDirty();
        }
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_175830_, 1.0);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.power_scale", (Object[])new Object[]{(double)tag.m_128451_("PowerScale") / 10.0}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN)), true);
        }
        return true;
    }

    public void onRelease(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        Vec3 pos;
        LivingEntity target;
        CompoundTag tag = instance.getOrCreateTag();
        int power = tag.m_128451_("PowerScale") / 10;
        tag.m_128405_("PowerScale", 0);
        instance.markDirty();
        if (power < 1) {
            return;
        }
        double cost = this.auraCost(entity, instance) * (double)power;
        if (SkillHelper.outOfAura(entity, cost)) {
            return;
        }
        entity.m_21011_(InteractionHand.MAIN_HAND, true);
        if (power >= 4) {
            this.addMasteryPoint(instance, entity);
        }
        if ((target = SkillHelper.getTargetingEntity(entity, 40.0, false, true)) != null) {
            pos = target.m_146892_();
        } else {
            BlockHitResult result = SkillHelper.getPlayerPOVHitResult(entity.f_19853_, (Entity)entity, ClipContext.Fluid.NONE, 40.0);
            pos = result.m_82450_().m_82520_(0.0, 0.5, 0.0);
        }
        this.spawnAuraBullets(instance, entity, pos, power);
    }

    private void spawnAuraBullets(ManasSkillInstance instance, LivingEntity entity, Vec3 pos, int amount) {
        int rot = 360 / amount;
        for (int i = 0; i < amount; ++i) {
            Vec3 bulletPos = entity.m_146892_().m_82520_(0.0, 2.0, 0.0).m_82549_(new Vec3(0.0, 2.0, 0.0).m_82535_(((float)(rot * i) - (float)rot / 2.0f) * ((float)Math.PI / 180)).m_82496_(-entity.m_146909_() * ((float)Math.PI / 180)).m_82524_(-entity.m_146908_() * ((float)Math.PI / 180)));
            AuraBulletProjectile bullet = new AuraBulletProjectile(entity.m_9236_(), entity);
            bullet.setSpeed(1.5f);
            bullet.m_146884_(bulletPos);
            bullet.shootFromRot(pos.m_82546_(bulletPos).m_82541_());
            bullet.setLife(50);
            bullet.setDamage(100.0f);
            bullet.m_20242_(true);
            bullet.setExplosionRadius(3.0f);
            bullet.setSize(0.5f);
            bullet.setSkill(instance);
            bullet.setApCost(this.magiculeCost(entity, instance));
            bullet.setColor(AuraBulletProjectile.AuraColor.YELLOW);
            entity.m_9236_().m_7967_((Entity)bullet);
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11705_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }
}

