/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.ability.battlewill.melee;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.battlewill.Battewill;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.world.TensuraGameRules;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class EarthshatterKickArt
extends Battewill {
    @Override
    public double learningCost() {
        return 150.0;
    }

    @Override
    public double auraCost(LivingEntity entity, ManasSkillInstance instance) {
        return 150.0;
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        if (!entity.m_20096_() || entity.isInFluidType()) {
            return;
        }
        if (SkillHelper.outOfAura(entity, instance)) {
            return;
        }
        Level level = entity.m_9236_();
        entity.m_21011_(InteractionHand.MAIN_HAND, true);
        this.addMasteryPoint(instance, entity);
        AABB aabb = entity.m_20191_().m_82400_(5.0);
        List list = level.m_6443_(LivingEntity.class, aabb, living -> living.m_20096_() && living != entity);
        if (!list.isEmpty()) {
            float damage = instance.isMastered(entity) ? 20.0f : 10.0f;
            for (LivingEntity target : list) {
                target.m_6469_((DamageSource)DamageSourceHelper.addSkillAndCost(DamageSource.m_19370_((LivingEntity)entity), 0.0, instance), damage);
                SkillHelper.knockBack(entity, target, 0.5f);
            }
        }
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_123813_);
        TensuraParticleHelper.spawnServerGroundSlamParticle(entity, 10, 2.0f);
        TensuraParticleHelper.spawnServerGroundSlamParticle(entity, 10, 3.0f);
        TensuraParticleHelper.spawnServerGroundSlamParticle(entity, 10, 4.0f);
        TensuraParticleHelper.spawnServerGroundSlamParticle(entity, 10, 5.0f);
        level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11913_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        if (TensuraGameRules.canSkillGrief(level)) {
            SkillHelper.launchBlock((Entity)entity, entity.m_20182_(), 5, 1, 0.5f, 0.5f, blockState -> {
                if (entity.m_217043_().m_188503_(3) != 1) {
                    return false;
                }
                return blockState.m_204336_(TensuraTags.Blocks.EARTH_DOMINATING);
            }, pos -> !pos.equals((Object)entity.m_20097_()) && !pos.equals((Object)entity.m_20097_().m_7495_()), instance);
        }
    }
}

