/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.worldgen.feature;

import com.mojang.serialization.Codec;
import dev.nweaver.happyghastmod.HappyGhastMod;
import dev.nweaver.happyghastmod.init.BlockInit;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class GhastlingIncubatorFeature
extends Feature<NoneFeatureConfiguration> {
    private static final int MAX_SEARCH_RADIUS = 15;
    private static final int PLACEMENT_RADIUS = 5;
    private static final float SPAWN_CHANCE = 1.0f;
    private static final int MIN_DISTANCE_BETWEEN_INCUBATORS = 10;
    private static int totalAttemptsCount = 0;
    private static int successfulPlacementsCount = 0;

    public GhastlingIncubatorFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
        HappyGhastMod.LOGGER.info(" GhastlingIncubatorFeature constructor called");
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos origin = context.m_159777_();
        RandomSource random = context.m_225041_();
        HappyGhastMod.LOGGER.info(" GhastlingIncubatorFeature.place attempt #{} at {}, dimension={}", (Object)(++totalAttemptsCount), (Object)origin, (Object)level.m_6018_().m_46472_().m_135782_());
        if (random.m_188501_() >= 1.0f) {
            HappyGhastMod.LOGGER.info(" Spawn chance check failed ({} >= {})", (Object)Float.valueOf(random.m_188501_()), (Object)Float.valueOf(1.0f));
            return false;
        }
        List<BlockPos> bonePositions = this.findAllBoneBlocks(level, origin, 15);
        if (bonePositions.isEmpty()) {
            HappyGhastMod.LOGGER.info(" No bone blocks found near {}", (Object)origin);
            return false;
        }
        HappyGhastMod.LOGGER.info(" Found {} bone blocks near {}", (Object)bonePositions.size(), (Object)origin);
        int startIndex = random.m_188503_(bonePositions.size());
        for (int i = 0; i < bonePositions.size(); ++i) {
            int index = (startIndex + i) % bonePositions.size();
            BlockPos bonePos = bonePositions.get(index);
            HappyGhastMod.LOGGER.info(" Checking bone block at {}", (Object)bonePos);
            if (this.hasIncubatorNearby(level, bonePos, 10)) {
                HappyGhastMod.LOGGER.info(" Skipping bone at {} - another incubator already exists nearby", (Object)bonePos);
                continue;
            }
            List<BlockPos> validPositions = this.findValidPlacementPositions(level, bonePos, 5);
            HappyGhastMod.LOGGER.info(" Found {} valid positions around bone at {}", (Object)validPositions.size(), (Object)bonePos);
            if (validPositions.isEmpty()) continue;
            BlockPos placePos = validPositions.get(random.m_188503_(validPositions.size()));
            HappyGhastMod.LOGGER.info(" Selected position {} for placement", (Object)placePos);
            if (!this.placeIncubator(level, placePos)) continue;
            HappyGhastMod.LOGGER.info(" \u0423\u0421\u041f\u0415\u0428\u041d\u041e: \u0418\u043d\u043a\u0443\u0431\u0430\u0442\u043e\u0440 \u0433\u0430\u0441\u0442\u043b\u0438\u043d\u0433\u0430 \u0440\u0430\u0437\u043c\u0435\u0449\u0435\u043d \u043d\u0430 {}, \u0432\u0441\u0435\u0433\u043e \u0440\u0430\u0437\u043c\u0435\u0449\u0435\u043d\u043e: {}", (Object)placePos, (Object)(++successfulPlacementsCount));
            return true;
        }
        HappyGhastMod.LOGGER.info(" Could not find suitable placement position for incubator near any bone block");
        return false;
    }

    private boolean hasIncubatorNearby(WorldGenLevel level, BlockPos center, int radius) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int y = -radius; y <= radius; ++y) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    mutablePos.m_122178_(center.m_123341_() + x, center.m_123342_() + y, center.m_123343_() + z);
                    if (!level.m_8055_((BlockPos)mutablePos).m_60713_((Block)BlockInit.GHASTLING_INCUBATOR.get())) continue;
                    HappyGhastMod.LOGGER.info(" Found existing incubator at {}", (Object)mutablePos);
                    return true;
                }
            }
        }
        return false;
    }

    private List<BlockPos> findAllBoneBlocks(WorldGenLevel level, BlockPos center, int maxRadius) {
        ArrayList<BlockPos> bonePositions = new ArrayList<BlockPos>();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        int blocksChecked = 0;
        for (int r = 3; r <= maxRadius; r += 3) {
            int found = 0;
            int sqRadius = r * r;
            for (int y = -r; y <= r; ++y) {
                for (int x = -r; x <= r; ++x) {
                    for (int z = -r; z <= r; ++z) {
                        if (x * x + y * y + z * z > sqRadius) continue;
                        mutablePos.m_122178_(center.m_123341_() + x, center.m_123342_() + y, center.m_123343_() + z);
                        ++blocksChecked;
                        if (!level.m_8055_((BlockPos)mutablePos).m_60713_(Blocks.f_50453_)) continue;
                        bonePositions.add(mutablePos.m_7949_());
                        HappyGhastMod.LOGGER.info(" Found bone block at {}", (Object)mutablePos);
                        if (++found < 5) continue;
                        HappyGhastMod.LOGGER.info(" Early exit after finding {} bone blocks, checked {} blocks in radius {}", (Object)found, (Object)blocksChecked, (Object)r);
                        return bonePositions;
                    }
                }
            }
            if (bonePositions.isEmpty()) continue;
            HappyGhastMod.LOGGER.info(" Stopping search after radius {} with {} bones found, checked {} blocks", (Object)r, (Object)bonePositions.size(), (Object)blocksChecked);
            break;
        }
        HappyGhastMod.LOGGER.info(" Bone block search complete, found {} blocks, checked {} blocks", (Object)bonePositions.size(), (Object)blocksChecked);
        return bonePositions;
    }

    private List<BlockPos> findValidPlacementPositions(WorldGenLevel level, BlockPos bonePos, int radius) {
        ArrayList<BlockPos> validPositions = new ArrayList<BlockPos>();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos belowPos = new BlockPos.MutableBlockPos();
        int blocksChecked = 0;
        int sqRadius = radius * radius;
        for (int y = -radius; y <= radius; ++y) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    if (x * x + y * y + z * z > sqRadius) continue;
                    mutablePos.m_122178_(bonePos.m_123341_() + x, bonePos.m_123342_() + y, bonePos.m_123343_() + z);
                    belowPos.m_122178_(mutablePos.m_123341_(), mutablePos.m_123342_() - 1, mutablePos.m_123343_());
                    ++blocksChecked;
                    boolean isEmpty = level.m_46859_((BlockPos)mutablePos);
                    boolean suitableGround = this.isSuitableGround(level, (BlockPos)belowPos);
                    if (!isEmpty || !suitableGround) continue;
                    validPositions.add(mutablePos.m_7949_());
                    HappyGhastMod.LOGGER.info(" Found valid position at {}, ground={}", (Object)mutablePos, (Object)level.m_8055_((BlockPos)belowPos).m_60734_().m_7705_());
                    if (validPositions.size() < 10) continue;
                    HappyGhastMod.LOGGER.info(" Early exit after finding {} valid positions, checked {} blocks", (Object)validPositions.size(), (Object)blocksChecked);
                    return validPositions;
                }
            }
        }
        HappyGhastMod.LOGGER.info(" Valid position search complete, found {} positions, checked {} blocks", (Object)validPositions.size(), (Object)blocksChecked);
        return validPositions;
    }

    private boolean isSuitableGround(WorldGenLevel level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        return state.m_60713_(Blocks.f_50135_) || state.m_60713_(Blocks.f_50136_);
    }

    private boolean placeIncubator(WorldGenLevel level, BlockPos pos) {
        boolean success = level.m_7731_(pos, ((Block)BlockInit.GHASTLING_INCUBATOR.get()).m_49966_(), 3);
        if (success) {
            HappyGhastMod.LOGGER.info(" GhastlingIncubatorFeature successfully placed at {}", (Object)pos);
        } else {
            HappyGhastMod.LOGGER.warn(" Failed to place GhastlingIncubatorFeature at {}", (Object)pos);
        }
        return success;
    }
}

