/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.worldgen.biome;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.nweaver.happyghastmod.HappyGhastMod;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;

public record AddIncubatorModifier(HolderSet<Biome> biomes, Holder<PlacedFeature> feature) implements BiomeModifier
{
    public static final Codec<AddIncubatorModifier> CODEC = RecordCodecBuilder.create(inst -> {
        HappyGhastMod.LOGGER.info("\ud83d\udd0d Creating AddIncubatorModifier CODEC");
        return inst.group((App)Biome.f_47432_.fieldOf("biomes").forGetter(AddIncubatorModifier::biomes), (App)PlacedFeature.f_191773_.fieldOf("feature").forGetter(AddIncubatorModifier::feature)).apply((Applicative)inst, (biomes, feature) -> {
            HappyGhastMod.LOGGER.info("\ud83d\udd0d Creating AddIncubatorModifier instance with biomes={} and feature={}", (Object)biomes.toString(), (Object)feature.toString());
            return new AddIncubatorModifier((HolderSet<Biome>)biomes, (Holder<PlacedFeature>)feature);
        });
    });

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        ResourceLocation biomeName = biome.m_203543_().map(key -> key.m_135782_()).orElse(null);
        if (phase == BiomeModifier.Phase.ADD) {
            boolean contains = this.biomes.m_203333_(biome);
            HappyGhastMod.LOGGER.info("\ud83d\udd0d BiomeModifier.modify called for biome={}, phase={}, contains={}", (Object)biomeName, (Object)phase, (Object)contains);
            if (contains) {
                ResourceLocation featureName = this.feature.m_203543_().map(key -> key.m_135782_()).orElse(null);
                HappyGhastMod.LOGGER.info("\u2705 Adding feature {} to biome {}", (Object)featureName, (Object)biomeName);
                builder.getGenerationSettings().m_204201_(GenerationStep.Decoration.UNDERGROUND_DECORATION, this.feature);
            }
        }
    }

    public Codec<? extends BiomeModifier> codec() {
        return CODEC;
    }
}

