/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FolderTextureLoader {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String TEXTURES_DIR = "happyghast_textures";

    public static File getTexturesFolder() {
        File gameDir = Minecraft.m_91087_().f_91069_;
        File texturesDir = new File(gameDir, TEXTURES_DIR);
        if (!texturesDir.exists()) {
            if (texturesDir.mkdirs()) {
                LOGGER.info("\u0421\u043e\u0437\u0434\u0430\u043d\u0430 \u0434\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0438\u044f \u0434\u043b\u044f \u0442\u0435\u043a\u0441\u0442\u0443\u0440: {}", (Object)texturesDir.getAbsolutePath());
            } else {
                LOGGER.error("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0434\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0438\u044e \u0434\u043b\u044f \u0442\u0435\u043a\u0441\u0442\u0443\u0440: {}", (Object)texturesDir.getAbsolutePath());
            }
        }
        return texturesDir;
    }

    public static List<File> getAvailableTextures() {
        File[] files;
        ArrayList<File> textures = new ArrayList<File>();
        File texturesDir = FolderTextureLoader.getTexturesFolder();
        if (texturesDir.exists() && texturesDir.isDirectory() && (files = texturesDir.listFiles((dir, name) -> name.toLowerCase().endsWith(".png"))) != null) {
            for (File file : files) {
                textures.add(file);
            }
        }
        return textures;
    }

    public static byte[] loadTextureData(File file) {
        try {
            return Files.readAllBytes(file.toPath());
        }
        catch (IOException e) {
            LOGGER.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u0442\u0435\u043a\u0441\u0442\u0443\u0440\u044b: {}", (Object)file.getAbsolutePath(), (Object)e);
            return null;
        }
    }

    public static void showFolderInfoMessage() {
        File folder = FolderTextureLoader.getTexturesFolder();
        if (Minecraft.m_91087_().f_91074_ != null) {
            Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237113_((String)("\u041f\u043e\u043b\u043e\u0436\u0438\u0442\u0435 PNG \u0442\u0435\u043a\u0441\u0442\u0443\u0440\u044b \u0432 \u043f\u0430\u043f\u043a\u0443: " + folder.getAbsolutePath())), false);
        }
    }
}

