/*
 * Decompiled with CFR 0.152.
 */
package dev.nweaver.happyghastmod.network;

import dev.nweaver.happyghastmod.client.texture.ClientCustomHarnessManager;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SyncCustomHarnessPacket {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String harnessId;
    private final String harnessName;
    private final String creatorName;
    private final byte[] saddleTextureData;
    private final byte[] glassesTextureData;
    private final byte[] accessoryTextureData;

    public SyncCustomHarnessPacket(String harnessId, String harnessName, String creatorName, byte[] saddleTextureData, byte[] glassesTextureData, byte[] accessoryTextureData) {
        this.harnessId = harnessId;
        this.harnessName = harnessName;
        this.creatorName = creatorName;
        this.saddleTextureData = saddleTextureData;
        this.glassesTextureData = glassesTextureData;
        this.accessoryTextureData = accessoryTextureData;
    }

    public static void encode(SyncCustomHarnessPacket packet, FriendlyByteBuf buffer) {
        buffer.m_130070_(packet.harnessId);
        buffer.m_130070_(packet.harnessName);
        buffer.m_130070_(packet.creatorName);
        SyncCustomHarnessPacket.writeNullableByteArray(buffer, packet.saddleTextureData);
        SyncCustomHarnessPacket.writeNullableByteArray(buffer, packet.glassesTextureData);
        SyncCustomHarnessPacket.writeNullableByteArray(buffer, packet.accessoryTextureData);
    }

    public static SyncCustomHarnessPacket decode(FriendlyByteBuf buffer) {
        String harnessId = buffer.m_130277_();
        String harnessName = buffer.m_130277_();
        String creatorName = buffer.m_130277_();
        byte[] saddleTextureData = SyncCustomHarnessPacket.readNullableByteArray(buffer);
        byte[] glassesTextureData = SyncCustomHarnessPacket.readNullableByteArray(buffer);
        byte[] accessoryTextureData = SyncCustomHarnessPacket.readNullableByteArray(buffer);
        return new SyncCustomHarnessPacket(harnessId, harnessName, creatorName, saddleTextureData, glassesTextureData, accessoryTextureData);
    }

    public static void handle(SyncCustomHarnessPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> SyncCustomHarnessPacket.handleClientSide(packet)));
        ctx.get().setPacketHandled(true);
    }

    private static void handleClientSide(SyncCustomHarnessPacket packet) {
        ClientCustomHarnessManager.registerCustomHarness(packet.harnessId, packet.harnessName, packet.creatorName, packet.saddleTextureData, packet.glassesTextureData, packet.accessoryTextureData);
    }

    private static void writeNullableByteArray(FriendlyByteBuf buffer, byte[] data) {
        if (data == null) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            buffer.m_130087_(data);
        }
    }

    private static byte[] readNullableByteArray(FriendlyByteBuf buffer) {
        boolean hasData = buffer.readBoolean();
        if (hasData) {
            return buffer.m_130052_();
        }
        return null;
    }
}

